<?php
/* Admin */

/**
 * Implement Ads.
 */
require get_template_directory() . '/inc/admin_ads.php';
require get_template_directory() . '/inc/menu-custom-fields.php';

if ( ! function_exists( 'toroplay_scripts_admin' ) ) :
/**
 * Enqueue scripts and styles in admin.
 */
function toroplay_scripts_admin($hook) {
    
    $myvars_tradmin = array( 
        'url' => admin_url( 'admin-ajax.php' ),
        'nonce' => wp_create_nonce( 'tr-admin' ),
        'action' => 'tr_admin',
        'loading' => __('Loading', 'toroplay')
    );
    wp_enqueue_script('tr_admin', get_template_directory_uri().'/js/admin.js',array('jquery'), TR_THEMEVERSION,true);
    wp_localize_script( 'tr_admin', 'tradmin', $myvars_tradmin );
    $cdn = '//maxcdn.bootstrapcdn.com';
    wp_enqueue_style( 'tricons-fontawesome', $cdn.'/font-awesome/4.7.0/css/font-awesome.min.css', array(), '1.0' );
    
    wp_enqueue_style( 'tricons-material', get_template_directory_uri() . '/css/material.css', array(), '1.0' );
    wp_enqueue_style( 'tr-admin', get_template_directory_uri() . '/css/admin.css', array(), '1.0' );
    
}
endif;
add_action( 'admin_enqueue_scripts', 'toroplay_scripts_admin' );

add_action('wp_ajax_tr_admin', 'tr_admin');
add_action('wp_ajax_nopriv_tr_admin', 'tr_admin');
/**
 * Tr Admin Ajax
 */
function tr_admin(){
        
    if(!wp_verify_nonce( $_POST['nonce'], 'tr-admin' ) and !current_user_can('administrator')){
        exit();
    }
    
    if(isset($_POST['action']) and $_POST['action']=='tr_admin'){
        
        
        $array = array(
          'AAIco-3d_rotation' => 'MT 3d_rotation',
          'AAIco-ac_unit' => 'MT Ac_unit',
          'AAIco-access_alarm' => 'MT Access_alarm',
          'AAIco-access_alarms' => 'MT Access_alarms',
          'AAIco-access_time' => 'MT Access_time',
          'AAIco-accessibility' => 'MT Accessibility',
          'AAIco-accessible' => 'MT Accessible',
          'AAIco-account_balance' => 'MT Account_balance',
          'AAIco-account_balance_wallet' => 'MT Account_balance_wallet',
          'AAIco-account_box' => 'MT Account_box',
          'AAIco-account_circle' => 'MT Account_circle',
          'AAIco-adb' => 'MT Adb',
          'AAIco-add' => 'MT Add',
          'AAIco-add_a_photo' => 'MT Add_a_photo',
          'AAIco-add_alarm' => 'MT Add_alarm',
          'AAIco-add_alert' => 'MT Add_alert',
          'AAIco-add_box' => 'MT Add_box',
          'AAIco-add_circle' => 'MT Add_circle',
          'AAIco-add_circle_outline' => 'MT Add_circle_outline',
          'AAIco-add_location' => 'MT Add_location',
          'AAIco-add_shopping_cart' => 'MT Add_shopping_cart',
          'AAIco-add_to_photos' => 'MT Add_to_photos',
          'AAIco-add_to_queue' => 'MT Add_to_queue',
          'AAIco-adjust' => 'MT Adjust',
          'AAIco-airline_seat_flat' => 'MT Airline_seat_flat',
          'AAIco-airline_seat_flat_angled' => 'MT Airline_seat_flat_angled',
          'AAIco-airline_seat_individual_suite' => 'MT Airline_seat_individual_suite',
          'AAIco-airline_seat_legroom_extra' => 'MT Airline_seat_legroom_extra',
          'AAIco-airline_seat_legroom_normal' => 'MT Airline_seat_legroom_normal',
          'AAIco-airline_seat_legroom_reduced' => 'MT Airline_seat_legroom_reduced',
          'AAIco-airline_seat_recline_extra' => 'MT Airline_seat_recline_extra',
          'AAIco-airline_seat_recline_normal' => 'MT Airline_seat_recline_normal',
          'AAIco-airplanemode_active' => 'MT Airplanemode_active',
          'AAIco-airplanemode_inactive' => 'MT Airplanemode_inactive',
          'AAIco-airplay' => 'MT Airplay',
          'AAIco-airport_shuttle' => 'MT Airport_shuttle',
          'AAIco-alarm' => 'MT Alarm',
          'AAIco-alarm_add' => 'MT Alarm_add',
          'AAIco-alarm_off' => 'MT Alarm_off',
          'AAIco-alarm_on' => 'MT Alarm_on',
          'AAIco-album' => 'MT Album',
          'AAIco-all_inclusive' => 'MT All_inclusive',
          'AAIco-all_out' => 'MT All_out',
          'AAIco-android' => 'MT Android',
          'AAIco-announcement' => 'MT Announcement',
          'AAIco-apps' => 'MT Apps',
          'AAIco-archive' => 'MT Archive',
          'AAIco-arrow_back' => 'MT Arrow_back',
          'AAIco-arrow_downward' => 'MT Arrow_downward',
          'AAIco-arrow_drop_down' => 'MT Arrow_drop_down',
          'AAIco-arrow_drop_down_circle' => 'MT Arrow_drop_down_circle',
          'AAIco-arrow_drop_up' => 'MT Arrow_drop_up',
          'AAIco-arrow_forward' => 'MT Arrow_forward',
          'AAIco-arrow_upward' => 'MT Arrow_upward',
          'AAIco-art_track' => 'MT Art_track',
          'AAIco-aspect_ratio' => 'MT Aspect_ratio',
          'AAIco-assessment' => 'MT Assessment',
          'AAIco-assignment' => 'MT Assignment',
          'AAIco-assignment_ind' => 'MT Assignment_ind',
          'AAIco-assignment_late' => 'MT Assignment_late',
          'AAIco-assignment_return' => 'MT Assignment_return',
          'AAIco-assignment_returned' => 'MT Assignment_returned',
          'AAIco-assignment_turned_in' => 'MT Assignment_turned_in',
          'AAIco-assistant' => 'MT Assistant',
          'AAIco-assistant_photo' => 'MT Assistant_photo',
          'AAIco-attach_file' => 'MT Attach_file',
          'AAIco-attach_money' => 'MT Attach_money',
          'AAIco-attachment' => 'MT Attachment',
          'AAIco-audiotrack' => 'MT Audiotrack',
          'AAIco-autorenew' => 'MT Autorenew',
          'AAIco-av_timer' => 'MT Av_timer',
          'AAIco-backspace' => 'MT Backspace',
          'AAIco-backup' => 'MT Backup',
          'AAIco-battery_alert' => 'MT Battery_alert',
          'AAIco-battery_charging_full' => 'MT Battery_charging_full',
          'AAIco-battery_full' => 'MT Battery_full',
          'AAIco-battery_std' => 'MT Battery_std',
          'AAIco-battery_unknown' => 'MT Battery_unknown',
          'AAIco-beach_access' => 'MT Beach_access',
          'AAIco-beenhere' => 'MT Beenhere',
          'AAIco-block' => 'MT Block',
          'AAIco-bluetooth' => 'MT Bluetooth',
          'AAIco-bluetooth_audio' => 'MT Bluetooth_audio',
          'AAIco-bluetooth_connected' => 'MT Bluetooth_connected',
          'AAIco-bluetooth_disabled' => 'MT Bluetooth_disabled',
          'AAIco-bluetooth_searching' => 'MT Bluetooth_searching',
          'AAIco-blur_circular' => 'MT Blur_circular',
          'AAIco-blur_linear' => 'MT Blur_linear',
          'AAIco-blur_off' => 'MT Blur_off',
          'AAIco-blur_on' => 'MT Blur_on',
          'AAIco-book' => 'MT Book',
          'AAIco-bookmark' => 'MT Bookmark',
          'AAIco-bookmark_border' => 'MT Bookmark_border',
          'AAIco-border_all' => 'MT Border_all',
          'AAIco-border_bottom' => 'MT Border_bottom',
          'AAIco-border_clear' => 'MT Border_clear',
          'AAIco-border_color' => 'MT Border_color',
          'AAIco-border_horizontal' => 'MT Border_horizontal',
          'AAIco-border_inner' => 'MT Border_inner',
          'AAIco-border_left' => 'MT Border_left',
          'AAIco-border_outer' => 'MT Border_outer',
          'AAIco-border_right' => 'MT Border_right',
          'AAIco-border_style' => 'MT Border_style',
          'AAIco-border_top' => 'MT Border_top',
          'AAIco-border_vertical' => 'MT Border_vertical',
          'AAIco-branding_watermark' => 'MT Branding_watermark',
          'AAIco-brightness_1' => 'MT Brightness_1',
          'AAIco-brightness_2' => 'MT Brightness_2',
          'AAIco-brightness_3' => 'MT Brightness_3',
          'AAIco-brightness_4' => 'MT Brightness_4',
          'AAIco-brightness_5' => 'MT Brightness_5',
          'AAIco-brightness_6' => 'MT Brightness_6',
          'AAIco-brightness_7' => 'MT Brightness_7',
          'AAIco-brightness_auto' => 'MT Brightness_auto',
          'AAIco-brightness_high' => 'MT Brightness_high',
          'AAIco-brightness_low' => 'MT Brightness_low',
          'AAIco-brightness_medium' => 'MT Brightness_medium',
          'AAIco-broken_image' => 'MT Broken_image',
          'AAIco-brush' => 'MT Brush',
          'AAIco-bubble_chart' => 'MT Bubble_chart',
          'AAIco-bug_report' => 'MT Bug_report',
          'AAIco-build' => 'MT Build',
          'AAIco-burst_mode' => 'MT Burst_mode',
          'AAIco-business' => 'MT Business',
          'AAIco-business_center' => 'MT Business_center',
          'AAIco-cached' => 'MT Cached',
          'AAIco-cake' => 'MT Cake',
          'AAIco-call' => 'MT Call',
          'AAIco-call_end' => 'MT Call_end',
          'AAIco-call_made' => 'MT Call_made',
          'AAIco-call_merge' => 'MT Call_merge',
          'AAIco-call_missed' => 'MT Call_missed',
          'AAIco-call_missed_outgoing' => 'MT Call_missed_outgoing',
          'AAIco-call_received' => 'MT Call_received',
          'AAIco-call_split' => 'MT Call_split',
          'AAIco-call_to_action' => 'MT Call_to_action',
          'AAIco-camera' => 'MT Camera',
          'AAIco-camera_alt' => 'MT Camera_alt',
          'AAIco-camera_enhance' => 'MT Camera_enhance',
          'AAIco-camera_front' => 'MT Camera_front',
          'AAIco-camera_rear' => 'MT Camera_rear',
          'AAIco-camera_roll' => 'MT Camera_roll',
          'AAIco-cancel' => 'MT Cancel',
          'AAIco-card_giftcard' => 'MT Card_giftcard',
          'AAIco-card_membership' => 'MT Card_membership',
          'AAIco-card_travel' => 'MT Card_travel',
          'AAIco-casino' => 'MT Casino',
          'AAIco-cast' => 'MT Cast',
          'AAIco-cast_connected' => 'MT Cast_connected',
          'AAIco-center_focus_strong' => 'MT Center_focus_strong',
          'AAIco-center_focus_weak' => 'MT Center_focus_weak',
          'AAIco-change_history' => 'MT Change_history',
          'AAIco-chat' => 'MT Chat',
          'AAIco-chat_bubble' => 'MT Chat_bubble',
          'AAIco-chat_bubble_outline' => 'MT Chat_bubble_outline',
          'AAIco-check' => 'MT Check',
          'AAIco-check_box' => 'MT Check_box',
          'AAIco-check_box_outline_blank' => 'MT Check_box_outline_blank',
          'AAIco-check_circle' => 'MT Check_circle',
          'AAIco-chevron_left' => 'MT Chevron_left',
          'AAIco-chevron_right' => 'MT Chevron_right',
          'AAIco-child_care' => 'MT Child_care',
          'AAIco-child_friendly' => 'MT Child_friendly',
          'AAIco-chrome_reader_mode' => 'MT Chrome_reader_mode',
          'AAIco-class' => 'MT Class',
          'AAIco-clear' => 'MT Clear',
          'AAIco-clear_all' => 'MT Clear_all',
          'AAIco-close' => 'MT Close',
          'AAIco-closed_caption' => 'MT Closed_caption',
          'AAIco-cloud' => 'MT Cloud',
          'AAIco-cloud_circle' => 'MT Cloud_circle',
          'AAIco-cloud_done' => 'MT Cloud_done',
          'AAIco-cloud_download' => 'MT Cloud_download',
          'AAIco-cloud_off' => 'MT Cloud_off',
          'AAIco-cloud_queue' => 'MT Cloud_queue',
          'AAIco-cloud_upload' => 'MT Cloud_upload',
          'AAIco-code' => 'MT Code',
          'AAIco-collections' => 'MT Collections',
          'AAIco-collections_bookmark' => 'MT Collections_bookmark',
          'AAIco-color_lens' => 'MT Color_lens',
          'AAIco-colorize' => 'MT Colorize',
          'AAIco-comment' => 'MT Comment',
          'AAIco-compare' => 'MT Compare',
          'AAIco-compare_arrows' => 'MT Compare_arrows',
          'AAIco-computer' => 'MT Computer',
          'AAIco-confirmation_number' => 'MT Confirmation_number',
          'AAIco-contact_mail' => 'MT Contact_mail',
          'AAIco-contact_phone' => 'MT Contact_phone',
          'AAIco-contacts' => 'MT Contacts',
          'AAIco-content_copy' => 'MT Content_copy',
          'AAIco-content_cut' => 'MT Content_cut',
          'AAIco-content_paste' => 'MT Content_paste',
          'AAIco-control_point' => 'MT Control_point',
          'AAIco-control_point_duplicate' => 'MT Control_point_duplicate',
          'AAIco-copyright' => 'MT Copyright',
          'AAIco-create' => 'MT Create',
          'AAIco-create_new_folder' => 'MT Create_new_folder',
          'AAIco-credit_card' => 'MT Credit_card',
          'AAIco-crop' => 'MT Crop',
          'AAIco-crop_16_9' => 'MT Crop_16_9',
          'AAIco-crop_3_2' => 'MT Crop_3_2',
          'AAIco-crop_5_4' => 'MT Crop_5_4',
          'AAIco-crop_7_5' => 'MT Crop_7_5',
          'AAIco-crop_din' => 'MT Crop_din',
          'AAIco-crop_free' => 'MT Crop_free',
          'AAIco-crop_landscape' => 'MT Crop_landscape',
          'AAIco-crop_original' => 'MT Crop_original',
          'AAIco-crop_portrait' => 'MT Crop_portrait',
          'AAIco-crop_rotate' => 'MT Crop_rotate',
          'AAIco-crop_square' => 'MT Crop_square',
          'AAIco-dashboard' => 'MT Dashboard',
          'AAIco-data_usage' => 'MT Data_usage',
          'AAIco-date_range' => 'MT Date_range',
          'AAIco-dehaze' => 'MT Dehaze',
          'AAIco-delete' => 'MT Delete',
          'AAIco-delete_forever' => 'MT Delete_forever',
          'AAIco-delete_sweep' => 'MT Delete_sweep',
          'AAIco-description' => 'MT Description',
          'AAIco-desktop_mac' => 'MT Desktop_mac',
          'AAIco-desktop_windows' => 'MT Desktop_windows',
          'AAIco-details' => 'MT Details',
          'AAIco-developer_board' => 'MT Developer_board',
          'AAIco-developer_mode' => 'MT Developer_mode',
          'AAIco-device_hub' => 'MT Device_hub',
          'AAIco-devices' => 'MT Devices',
          'AAIco-devices_other' => 'MT Devices_other',
          'AAIco-dialer_sip' => 'MT Dialer_sip',
          'AAIco-dialpad' => 'MT Dialpad',
          'AAIco-directions' => 'MT Directions',
          'AAIco-directions_bike' => 'MT Directions_bike',
          'AAIco-directions_boat' => 'MT Directions_boat',
          'AAIco-directions_bus' => 'MT Directions_bus',
          'AAIco-directions_car' => 'MT Directions_car',
          'AAIco-directions_railway' => 'MT Directions_railway',
          'AAIco-directions_run' => 'MT Directions_run',
          'AAIco-directions_subway' => 'MT Directions_subway',
          'AAIco-directions_transit' => 'MT Directions_transit',
          'AAIco-directions_walk' => 'MT Directions_walk',
          'AAIco-disc_full' => 'MT Disc_full',
          'AAIco-dns' => 'MT Dns',
          'AAIco-do_not_disturb' => 'MT Do_not_disturb',
          'AAIco-do_not_disturb_alt' => 'MT Do_not_disturb_alt',
          'AAIco-do_not_disturb_off' => 'MT Do_not_disturb_off',
          'AAIco-do_not_disturb_on' => 'MT Do_not_disturb_on',
          'AAIco-dock' => 'MT Dock',
          'AAIco-domain' => 'MT Domain',
          'AAIco-done' => 'MT Done',
          'AAIco-done_all' => 'MT Done_all',
          'AAIco-donut_large' => 'MT Donut_large',
          'AAIco-donut_small' => 'MT Donut_small',
          'AAIco-drafts' => 'MT Drafts',
          'AAIco-drag_handle' => 'MT Drag_handle',
          'AAIco-drive_eta' => 'MT Drive_eta',
          'AAIco-dvr' => 'MT Dvr',
          'AAIco-edit' => 'MT Edit',
          'AAIco-edit_location' => 'MT Edit_location',
          'AAIco-eject' => 'MT Eject',
          'AAIco-email' => 'MT Email',
          'AAIco-enhanced_encryption' => 'MT Enhanced_encryption',
          'AAIco-equalizer' => 'MT Equalizer',
          'AAIco-error' => 'MT Error',
          'AAIco-error_outline' => 'MT Error_outline',
          'AAIco-euro_symbol' => 'MT Euro_symbol',
          'AAIco-ev_station' => 'MT Ev_station',
          'AAIco-event' => 'MT Event',
          'AAIco-event_available' => 'MT Event_available',
          'AAIco-event_busy' => 'MT Event_busy',
          'AAIco-event_note' => 'MT Event_note',
          'AAIco-event_seat' => 'MT Event_seat',
          'AAIco-exit_to_app' => 'MT Exit_to_app',
          'AAIco-expand_less' => 'MT Expand_less',
          'AAIco-expand_more' => 'MT Expand_more',
          'AAIco-explicit' => 'MT Explicit',
          'AAIco-explore' => 'MT Explore',
          'AAIco-exposure' => 'MT Exposure',
          'AAIco-exposure_neg_1' => 'MT Exposure_neg_1',
          'AAIco-exposure_neg_2' => 'MT Exposure_neg_2',
          'AAIco-exposure_plus_1' => 'MT Exposure_plus_1',
          'AAIco-exposure_plus_2' => 'MT Exposure_plus_2',
          'AAIco-exposure_zero' => 'MT Exposure_zero',
          'AAIco-extension' => 'MT Extension',
          'AAIco-face' => 'MT Face',
          'AAIco-fast_forward' => 'MT Fast_forward',
          'AAIco-fast_rewind' => 'MT Fast_rewind',
          'AAIco-favorite' => 'MT Favorite',
          'AAIco-favorite_border' => 'MT Favorite_border',
          'AAIco-featured_play_list' => 'MT Featured_play_list',
          'AAIco-featured_video' => 'MT Featured_video',
          'AAIco-feedback' => 'MT Feedback',
          'AAIco-fiber_dvr' => 'MT Fiber_dvr',
          'AAIco-fiber_manual_record' => 'MT Fiber_manual_record',
          'AAIco-fiber_new' => 'MT Fiber_new',
          'AAIco-fiber_pin' => 'MT Fiber_pin',
          'AAIco-fiber_smart_record' => 'MT Fiber_smart_record',
          'AAIco-file_download' => 'MT File_download',
          'AAIco-file_upload' => 'MT File_upload',
          'AAIco-filter' => 'MT Filter',
          'AAIco-filter_1' => 'MT Filter_1',
          'AAIco-filter_2' => 'MT Filter_2',
          'AAIco-filter_3' => 'MT Filter_3',
          'AAIco-filter_4' => 'MT Filter_4',
          'AAIco-filter_5' => 'MT Filter_5',
          'AAIco-filter_6' => 'MT Filter_6',
          'AAIco-filter_7' => 'MT Filter_7',
          'AAIco-filter_8' => 'MT Filter_8',
          'AAIco-filter_9' => 'MT Filter_9',
          'AAIco-filter_9_plus' => 'MT Filter_9_plus',
          'AAIco-filter_b_and_w' => 'MT Filter_b_and_w',
          'AAIco-filter_center_focus' => 'MT Filter_center_focus',
          'AAIco-filter_drama' => 'MT Filter_drama',
          'AAIco-filter_frames' => 'MT Filter_frames',
          'AAIco-filter_hdr' => 'MT Filter_hdr',
          'AAIco-filter_list' => 'MT Filter_list',
          'AAIco-filter_none' => 'MT Filter_none',
          'AAIco-filter_tilt_shift' => 'MT Filter_tilt_shift',
          'AAIco-filter_vintage' => 'MT Filter_vintage',
          'AAIco-find_in_page' => 'MT Find_in_page',
          'AAIco-find_replace' => 'MT Find_replace',
          'AAIco-fingerprint' => 'MT Fingerprint',
          'AAIco-first_page' => 'MT First_page',
          'AAIco-fitness_center' => 'MT Fitness_center',
          'AAIco-flag' => 'MT Flag',
          'AAIco-flare' => 'MT Flare',
          'AAIco-flash_auto' => 'MT Flash_auto',
          'AAIco-flash_off' => 'MT Flash_off',
          'AAIco-flash_on' => 'MT Flash_on',
          'AAIco-flight' => 'MT Flight',
          'AAIco-flight_land' => 'MT Flight_land',
          'AAIco-flight_takeoff' => 'MT Flight_takeoff',
          'AAIco-flip' => 'MT Flip',
          'AAIco-flip_to_back' => 'MT Flip_to_back',
          'AAIco-flip_to_front' => 'MT Flip_to_front',
          'AAIco-folder' => 'MT Folder',
          'AAIco-folder_open' => 'MT Folder_open',
          'AAIco-folder_shared' => 'MT Folder_shared',
          'AAIco-folder_special' => 'MT Folder_special',
          'AAIco-font_download' => 'MT Font_download',
          'AAIco-format_align_center' => 'MT Format_align_center',
          'AAIco-format_align_justify' => 'MT Format_align_justify',
          'AAIco-format_align_left' => 'MT Format_align_left',
          'AAIco-format_align_right' => 'MT Format_align_right',
          'AAIco-format_bold' => 'MT Format_bold',
          'AAIco-format_clear' => 'MT Format_clear',
          'AAIco-format_color_fill' => 'MT Format_color_fill',
          'AAIco-format_color_reset' => 'MT Format_color_reset',
          'AAIco-format_color_text' => 'MT Format_color_text',
          'AAIco-format_indent_decrease' => 'MT Format_indent_decrease',
          'AAIco-format_indent_increase' => 'MT Format_indent_increase',
          'AAIco-format_italic' => 'MT Format_italic',
          'AAIco-format_line_spacing' => 'MT Format_line_spacing',
          'AAIco-format_list_bulleted' => 'MT Format_list_bulleted',
          'AAIco-format_list_numbered' => 'MT Format_list_numbered',
          'AAIco-format_paint' => 'MT Format_paint',
          'AAIco-format_quote' => 'MT Format_quote',
          'AAIco-format_shapes' => 'MT Format_shapes',
          'AAIco-format_size' => 'MT Format_size',
          'AAIco-format_strikethrough' => 'MT Format_strikethrough',
          'AAIco-format_textdirection_l_to_r' => 'MT Format_textdirection_l_to_r',
          'AAIco-format_textdirection_r_to_l' => 'MT Format_textdirection_r_to_l',
          'AAIco-format_underlined' => 'MT Format_underlined',
          'AAIco-forum' => 'MT Forum',
          'AAIco-forward' => 'MT Forward',
          'AAIco-forward_10' => 'MT Forward_10',
          'AAIco-forward_30' => 'MT Forward_30',
          'AAIco-forward_5' => 'MT Forward_5',
          'AAIco-free_breakfast' => 'MT Free_breakfast',
          'AAIco-fullscreen' => 'MT Fullscreen',
          'AAIco-fullscreen_exit' => 'MT Fullscreen_exit',
          'AAIco-functions' => 'MT Functions',
          'AAIco-g_translate' => 'MT G_translate',
          'AAIco-gamepad' => 'MT Gamepad',
          'AAIco-games' => 'MT Games',
          'AAIco-gavel' => 'MT Gavel',
          'AAIco-gesture' => 'MT Gesture',
          'AAIco-get_app' => 'MT Get_app',
          'AAIco-gif' => 'MT Gif',
          'AAIco-golf_course' => 'MT Golf_course',
          'AAIco-gps_fixed' => 'MT Gps_fixed',
          'AAIco-gps_not_fixed' => 'MT Gps_not_fixed',
          'AAIco-gps_off' => 'MT Gps_off',
          'AAIco-grade' => 'MT Grade',
          'AAIco-gradient' => 'MT Gradient',
          'AAIco-grain' => 'MT Grain',
          'AAIco-graphic_eq' => 'MT Graphic_eq',
          'AAIco-grid_off' => 'MT Grid_off',
          'AAIco-grid_on' => 'MT Grid_on',
          'AAIco-group' => 'MT Group',
          'AAIco-group_add' => 'MT Group_add',
          'AAIco-group_work' => 'MT Group_work',
          'AAIco-hd' => 'MT Hd',
          'AAIco-hdr_off' => 'MT Hdr_off',
          'AAIco-hdr_on' => 'MT Hdr_on',
          'AAIco-hdr_strong' => 'MT Hdr_strong',
          'AAIco-hdr_weak' => 'MT Hdr_weak',
          'AAIco-headset' => 'MT Headset',
          'AAIco-headset_mic' => 'MT Headset_mic',
          'AAIco-healing' => 'MT Healing',
          'AAIco-hearing' => 'MT Hearing',
          'AAIco-help' => 'MT Help',
          'AAIco-help_outline' => 'MT Help_outline',
          'AAIco-high_quality' => 'MT High_quality',
          'AAIco-highlight' => 'MT Highlight',
          'AAIco-highlight_off' => 'MT Highlight_off',
          'AAIco-history' => 'MT History',
          'AAIco-home' => 'MT Home',
          'AAIco-hot_tub' => 'MT Hot_tub',
          'AAIco-hotel' => 'MT Hotel',
          'AAIco-hourglass_empty' => 'MT Hourglass_empty',
          'AAIco-hourglass_full' => 'MT Hourglass_full',
          'AAIco-http' => 'MT Http',
          'AAIco-https' => 'MT Https',
          'AAIco-image' => 'MT Image',
          'AAIco-image_aspect_ratio' => 'MT Image_aspect_ratio',
          'AAIco-import_contacts' => 'MT Import_contacts',
          'AAIco-import_export' => 'MT Import_export',
          'AAIco-important_devices' => 'MT Important_devices',
          'AAIco-inbox' => 'MT Inbox',
          'AAIco-indeterminate_check_box' => 'MT Indeterminate_check_box',
          'AAIco-info' => 'MT Info',
          'AAIco-info_outline' => 'MT Info_outline',
          'AAIco-input' => 'MT Input',
          'AAIco-insert_chart' => 'MT Insert_chart',
          'AAIco-insert_comment' => 'MT Insert_comment',
          'AAIco-insert_drive_file' => 'MT Insert_drive_file',
          'AAIco-insert_emoticon' => 'MT Insert_emoticon',
          'AAIco-insert_invitation' => 'MT Insert_invitation',
          'AAIco-insert_link' => 'MT Insert_link',
          'AAIco-insert_photo' => 'MT Insert_photo',
          'AAIco-invert_colors' => 'MT Invert_colors',
          'AAIco-invert_colors_off' => 'MT Invert_colors_off',
          'AAIco-iso' => 'MT Iso',
          'AAIco-keyboard' => 'MT Keyboard',
          'AAIco-keyboard_arrow_down' => 'MT Keyboard_arrow_down',
          'AAIco-keyboard_arrow_left' => 'MT Keyboard_arrow_left',
          'AAIco-keyboard_arrow_right' => 'MT Keyboard_arrow_right',
          'AAIco-keyboard_arrow_up' => 'MT Keyboard_arrow_up',
          'AAIco-keyboard_backspace' => 'MT Keyboard_backspace',
          'AAIco-keyboard_capslock' => 'MT Keyboard_capslock',
          'AAIco-keyboard_hide' => 'MT Keyboard_hide',
          'AAIco-keyboard_return' => 'MT Keyboard_return',
          'AAIco-keyboard_tab' => 'MT Keyboard_tab',
          'AAIco-keyboard_voice' => 'MT Keyboard_voice',
          'AAIco-kitchen' => 'MT Kitchen',
          'AAIco-label' => 'MT Label',
          'AAIco-label_outline' => 'MT Label_outline',
          'AAIco-landscape' => 'MT Landscape',
          'AAIco-language' => 'MT Language',
          'AAIco-laptop' => 'MT Laptop',
          'AAIco-laptop_chromebook' => 'MT Laptop_chromebook',
          'AAIco-laptop_mac' => 'MT Laptop_mac',
          'AAIco-laptop_windows' => 'MT Laptop_windows',
          'AAIco-last_page' => 'MT Last_page',
          'AAIco-launch' => 'MT Launch',
          'AAIco-layers' => 'MT Layers',
          'AAIco-layers_clear' => 'MT Layers_clear',
          'AAIco-leak_add' => 'MT Leak_add',
          'AAIco-leak_remove' => 'MT Leak_remove',
          'AAIco-lens' => 'MT Lens',
          'AAIco-library_add' => 'MT Library_add',
          'AAIco-library_books' => 'MT Library_books',
          'AAIco-library_music' => 'MT Library_music',
          'AAIco-lightbulb_outline' => 'MT Lightbulb_outline',
          'AAIco-line_style' => 'MT Line_style',
          'AAIco-line_weight' => 'MT Line_weight',
          'AAIco-linear_scale' => 'MT Linear_scale',
          'AAIco-link' => 'MT Link',
          'AAIco-linked_camera' => 'MT Linked_camera',
          'AAIco-list' => 'MT List',
          'AAIco-live_help' => 'MT Live_help',
          'AAIco-live_tv' => 'MT Live_tv',
          'AAIco-local_activity' => 'MT Local_activity',
          'AAIco-local_airport' => 'MT Local_airport',
          'AAIco-local_atm' => 'MT Local_atm',
          'AAIco-local_bar' => 'MT Local_bar',
          'AAIco-local_cafe' => 'MT Local_cafe',
          'AAIco-local_car_wash' => 'MT Local_car_wash',
          'AAIco-local_convenience_store' => 'MT Local_convenience_store',
          'AAIco-local_dining' => 'MT Local_dining',
          'AAIco-local_drink' => 'MT Local_drink',
          'AAIco-local_florist' => 'MT Local_florist',
          'AAIco-local_gas_station' => 'MT Local_gas_station',
          'AAIco-local_grocery_store' => 'MT Local_grocery_store',
          'AAIco-local_hospital' => 'MT Local_hospital',
          'AAIco-local_hotel' => 'MT Local_hotel',
          'AAIco-local_laundry_service' => 'MT Local_laundry_service',
          'AAIco-local_library' => 'MT Local_library',
          'AAIco-local_mall' => 'MT Local_mall',
          'AAIco-local_movies' => 'MT Local_movies',
          'AAIco-local_offer' => 'MT Local_offer',
          'AAIco-local_parking' => 'MT Local_parking',
          'AAIco-local_pharmacy' => 'MT Local_pharmacy',
          'AAIco-local_phone' => 'MT Local_phone',
          'AAIco-local_pizza' => 'MT Local_pizza',
          'AAIco-local_play' => 'MT Local_play',
          'AAIco-local_post_office' => 'MT Local_post_office',
          'AAIco-local_printshop' => 'MT Local_printshop',
          'AAIco-local_see' => 'MT Local_see',
          'AAIco-local_shipping' => 'MT Local_shipping',
          'AAIco-local_taxi' => 'MT Local_taxi',
          'AAIco-location_city' => 'MT Location_city',
          'AAIco-location_disabled' => 'MT Location_disabled',
          'AAIco-location_off' => 'MT Location_off',
          'AAIco-location_on' => 'MT Location_on',
          'AAIco-location_searching' => 'MT Location_searching',
          'AAIco-lock' => 'MT Lock',
          'AAIco-lock_open' => 'MT Lock_open',
          'AAIco-lock_outline' => 'MT Lock_outline',
          'AAIco-looks' => 'MT Looks',
          'AAIco-looks_3' => 'MT Looks_3',
          'AAIco-looks_4' => 'MT Looks_4',
          'AAIco-looks_5' => 'MT Looks_5',
          'AAIco-looks_6' => 'MT Looks_6',
          'AAIco-looks_one' => 'MT Looks_one',
          'AAIco-looks_two' => 'MT Looks_two',
          'AAIco-loop' => 'MT Loop',
          'AAIco-loupe' => 'MT Loupe',
          'AAIco-low_priority' => 'MT Low_priority',
          'AAIco-loyalty' => 'MT Loyalty',
          'AAIco-mail' => 'MT Mail',
          'AAIco-mail_outline' => 'MT Mail_outline',
          'AAIco-map' => 'MT Map',
          'AAIco-markunread' => 'MT Markunread',
          'AAIco-markunread_mailbox' => 'MT Markunread_mailbox',
          'AAIco-memory' => 'MT Memory',
          'AAIco-menu' => 'MT Menu',
          'AAIco-merge_type' => 'MT Merge_type',
          'AAIco-message' => 'MT Message',
          'AAIco-mic' => 'MT Mic',
          'AAIco-mic_none' => 'MT Mic_none',
          'AAIco-mic_off' => 'MT Mic_off',
          'AAIco-mms' => 'MT Mms',
          'AAIco-mode_comment' => 'MT Mode_comment',
          'AAIco-mode_edit' => 'MT Mode_edit',
          'AAIco-monetization_on' => 'MT Monetization_on',
          'AAIco-money_off' => 'MT Money_off',
          'AAIco-monochrome_photos' => 'MT Monochrome_photos',
          'AAIco-mood' => 'MT Mood',
          'AAIco-mood_bad' => 'MT Mood_bad',
          'AAIco-more' => 'MT More',
          'AAIco-more_horiz' => 'MT More_horiz',
          'AAIco-more_vert' => 'MT More_vert',
          'AAIco-motorcycle' => 'MT Motorcycle',
          'AAIco-mouse' => 'MT Mouse',
          'AAIco-move_to_inbox' => 'MT Move_to_inbox',
          'AAIco-movie' => 'MT Movie',
          'AAIco-movie_creation' => 'MT Movie_creation',
          'AAIco-movie_filter' => 'MT Movie_filter',
          'AAIco-multiline_chart' => 'MT Multiline_chart',
          'AAIco-music_note' => 'MT Music_note',
          'AAIco-music_video' => 'MT Music_video',
          'AAIco-my_location' => 'MT My_location',
          'AAIco-nature' => 'MT Nature',
          'AAIco-nature_people' => 'MT Nature_people',
          'AAIco-navigate_before' => 'MT Navigate_before',
          'AAIco-navigate_next' => 'MT Navigate_next',
          'AAIco-navigation' => 'MT Navigation',
          'AAIco-near_me' => 'MT Near_me',
          'AAIco-network_cell' => 'MT Network_cell',
          'AAIco-network_check' => 'MT Network_check',
          'AAIco-network_locked' => 'MT Network_locked',
          'AAIco-network_wifi' => 'MT Network_wifi',
          'AAIco-new_releases' => 'MT New_releases',
          'AAIco-next_week' => 'MT Next_week',
          'AAIco-nfc' => 'MT Nfc',
          'AAIco-no_encryption' => 'MT No_encryption',
          'AAIco-no_sim' => 'MT No_sim',
          'AAIco-not_interested' => 'MT Not_interested',
          'AAIco-note' => 'MT Note',
          'AAIco-note_add' => 'MT Note_add',
          'AAIco-notifications' => 'MT Notifications',
          'AAIco-notifications_active' => 'MT Notifications_active',
          'AAIco-notifications_none' => 'MT Notifications_none',
          'AAIco-notifications_off' => 'MT Notifications_off',
          'AAIco-notifications_paused' => 'MT Notifications_paused',
          'AAIco-offline_pin' => 'MT Offline_pin',
          'AAIco-ondemand_video' => 'MT Ondemand_video',
          'AAIco-opacity' => 'MT Opacity',
          'AAIco-open_in_browser' => 'MT Open_in_browser',
          'AAIco-open_in_new' => 'MT Open_in_new',
          'AAIco-open_with' => 'MT Open_with',
          'AAIco-pages' => 'MT Pages',
          'AAIco-pageview' => 'MT Pageview',
          'AAIco-palette' => 'MT Palette',
          'AAIco-pan_tool' => 'MT Pan_tool',
          'AAIco-panorama' => 'MT Panorama',
          'AAIco-panorama_fish_eye' => 'MT Panorama_fish_eye',
          'AAIco-panorama_horizontal' => 'MT Panorama_horizontal',
          'AAIco-panorama_vertical' => 'MT Panorama_vertical',
          'AAIco-panorama_wide_angle' => 'MT Panorama_wide_angle',
          'AAIco-party_mode' => 'MT Party_mode',
          'AAIco-pause' => 'MT Pause',
          'AAIco-pause_circle_filled' => 'MT Pause_circle_filled',
          'AAIco-pause_circle_outline' => 'MT Pause_circle_outline',
          'AAIco-payment' => 'MT Payment',
          'AAIco-people' => 'MT People',
          'AAIco-people_outline' => 'MT People_outline',
          'AAIco-perm_camera_mic' => 'MT Perm_camera_mic',
          'AAIco-perm_contact_calendar' => 'MT Perm_contact_calendar',
          'AAIco-perm_data_setting' => 'MT Perm_data_setting',
          'AAIco-perm_device_information' => 'MT Perm_device_information',
          'AAIco-perm_identity' => 'MT Perm_identity',
          'AAIco-perm_media' => 'MT Perm_media',
          'AAIco-perm_phone_msg' => 'MT Perm_phone_msg',
          'AAIco-perm_scan_wifi' => 'MT Perm_scan_wifi',
          'AAIco-person' => 'MT Person',
          'AAIco-person_add' => 'MT Person_add',
          'AAIco-person_outline' => 'MT Person_outline',
          'AAIco-person_pin' => 'MT Person_pin',
          'AAIco-person_pin_circle' => 'MT Person_pin_circle',
          'AAIco-personal_video' => 'MT Personal_video',
          'AAIco-pets' => 'MT Pets',
          'AAIco-phone' => 'MT Phone',
          'AAIco-phone_android' => 'MT Phone_android',
          'AAIco-phone_bluetooth_speaker' => 'MT Phone_bluetooth_speaker',
          'AAIco-phone_forwarded' => 'MT Phone_forwarded',
          'AAIco-phone_in_talk' => 'MT Phone_in_talk',
          'AAIco-phone_iphone' => 'MT Phone_iphone',
          'AAIco-phone_locked' => 'MT Phone_locked',
          'AAIco-phone_missed' => 'MT Phone_missed',
          'AAIco-phone_paused' => 'MT Phone_paused',
          'AAIco-phonelink' => 'MT Phonelink',
          'AAIco-phonelink_erase' => 'MT Phonelink_erase',
          'AAIco-phonelink_lock' => 'MT Phonelink_lock',
          'AAIco-phonelink_off' => 'MT Phonelink_off',
          'AAIco-phonelink_ring' => 'MT Phonelink_ring',
          'AAIco-phonelink_setup' => 'MT Phonelink_setup',
          'AAIco-photo' => 'MT Photo',
          'AAIco-photo_album' => 'MT Photo_album',
          'AAIco-photo_camera' => 'MT Photo_camera',
          'AAIco-photo_filter' => 'MT Photo_filter',
          'AAIco-photo_library' => 'MT Photo_library',
          'AAIco-photo_size_select_actual' => 'MT Photo_size_select_actual',
          'AAIco-photo_size_select_large' => 'MT Photo_size_select_large',
          'AAIco-photo_size_select_small' => 'MT Photo_size_select_small',
          'AAIco-picture_as_pdf' => 'MT Picture_as_pdf',
          'AAIco-picture_in_picture' => 'MT Picture_in_picture',
          'AAIco-picture_in_picture_alt' => 'MT Picture_in_picture_alt',
          'AAIco-pie_chart' => 'MT Pie_chart',
          'AAIco-pie_chart_outlined' => 'MT Pie_chart_outlined',
          'AAIco-pin_drop' => 'MT Pin_drop',
          'AAIco-place' => 'MT Place',
          'AAIco-play_arrow' => 'MT Play_arrow',
          'AAIco-play_circle_filled' => 'MT Play_circle_filled',
          'AAIco-play_circle_outline' => 'MT Play_circle_outline',
          'AAIco-play_for_work' => 'MT Play_for_work',
          'AAIco-playlist_add' => 'MT Playlist_add',
          'AAIco-playlist_add_check' => 'MT Playlist_add_check',
          'AAIco-playlist_play' => 'MT Playlist_play',
          'AAIco-plus_one' => 'MT Plus_one',
          'AAIco-poll' => 'MT Poll',
          'AAIco-polymer' => 'MT Polymer',
          'AAIco-pool' => 'MT Pool',
          'AAIco-portable_wifi_off' => 'MT Portable_wifi_off',
          'AAIco-portrait' => 'MT Portrait',
          'AAIco-power' => 'MT Power',
          'AAIco-power_input' => 'MT Power_input',
          'AAIco-power_settings_new' => 'MT Power_settings_new',
          'AAIco-pregnant_woman' => 'MT Pregnant_woman',
          'AAIco-present_to_all' => 'MT Present_to_all',
          'AAIco-print' => 'MT Print',
          'AAIco-priority_high' => 'MT Priority_high',
          'AAIco-public' => 'MT Public',
          'AAIco-publish' => 'MT Publish',
          'AAIco-query_builder' => 'MT Query_builder',
          'AAIco-question_answer' => 'MT Question_answer',
          'AAIco-queue' => 'MT Queue',
          'AAIco-queue_music' => 'MT Queue_music',
          'AAIco-queue_play_next' => 'MT Queue_play_next',
          'AAIco-radio' => 'MT Radio',
          'AAIco-radio_button_checked' => 'MT Radio_button_checked',
          'AAIco-radio_button_unchecked' => 'MT Radio_button_unchecked',
          'AAIco-rate_review' => 'MT Rate_review',
          'AAIco-receipt' => 'MT Receipt',
          'AAIco-recent_actors' => 'MT Recent_actors',
          'AAIco-record_voice_over' => 'MT Record_voice_over',
          'AAIco-redeem' => 'MT Redeem',
          'AAIco-redo' => 'MT Redo',
          'AAIco-refresh' => 'MT Refresh',
          'AAIco-remove' => 'MT Remove',
          'AAIco-remove_circle' => 'MT Remove_circle',
          'AAIco-remove_circle_outline' => 'MT Remove_circle_outline',
          'AAIco-remove_from_queue' => 'MT Remove_from_queue',
          'AAIco-remove_red_eye' => 'MT Remove_red_eye',
          'AAIco-remove_shopping_cart' => 'MT Remove_shopping_cart',
          'AAIco-reorder' => 'MT Reorder',
          'AAIco-repeat' => 'MT Repeat',
          'AAIco-repeat_one' => 'MT Repeat_one',
          'AAIco-replay' => 'MT Replay',
          'AAIco-replay_10' => 'MT Replay_10',
          'AAIco-replay_30' => 'MT Replay_30',
          'AAIco-replay_5' => 'MT Replay_5',
          'AAIco-reply' => 'MT Reply',
          'AAIco-reply_all' => 'MT Reply_all',
          'AAIco-report' => 'MT Report',
          'AAIco-report_problem' => 'MT Report_problem',
          'AAIco-restaurant' => 'MT Restaurant',
          'AAIco-restaurant_menu' => 'MT Restaurant_menu',
          'AAIco-restore' => 'MT Restore',
          'AAIco-restore_page' => 'MT Restore_page',
          'AAIco-ring_volume' => 'MT Ring_volume',
          'AAIco-room' => 'MT Room',
          'AAIco-room_service' => 'MT Room_service',
          'AAIco-rotate_90_degrees_ccw' => 'MT Rotate_90_degrees_ccw',
          'AAIco-rotate_left' => 'MT Rotate_left',
          'AAIco-rotate_right' => 'MT Rotate_right',
          'AAIco-rounded_corner' => 'MT Rounded_corner',
          'AAIco-router' => 'MT Router',
          'AAIco-rowing' => 'MT Rowing',
          'AAIco-rss_feed' => 'MT Rss_feed',
          'AAIco-rv_hookup' => 'MT Rv_hookup',
          'AAIco-satellite' => 'MT Satellite',
          'AAIco-save' => 'MT Save',
          'AAIco-scanner' => 'MT Scanner',
          'AAIco-schedule' => 'MT Schedule',
          'AAIco-school' => 'MT School',
          'AAIco-screen_lock_landscape' => 'MT Screen_lock_landscape',
          'AAIco-screen_lock_portrait' => 'MT Screen_lock_portrait',
          'AAIco-screen_lock_rotation' => 'MT Screen_lock_rotation',
          'AAIco-screen_rotation' => 'MT Screen_rotation',
          'AAIco-screen_share' => 'MT Screen_share',
          'AAIco-sd_card' => 'MT Sd_card',
          'AAIco-sd_storage' => 'MT Sd_storage',
          'AAIco-search' => 'MT Search',
          'AAIco-security' => 'MT Security',
          'AAIco-select_all' => 'MT Select_all',
          'AAIco-send' => 'MT Send',
          'AAIco-sentiment_dissatisfied' => 'MT Sentiment_dissatisfied',
          'AAIco-sentiment_neutral' => 'MT Sentiment_neutral',
          'AAIco-sentiment_satisfied' => 'MT Sentiment_satisfied',
          'AAIco-sentiment_very_dissatisfied' => 'MT Sentiment_very_dissatisfied',
          'AAIco-sentiment_very_satisfied' => 'MT Sentiment_very_satisfied',
          'AAIco-settings' => 'MT Settings',
          'AAIco-settings_applications' => 'MT Settings_applications',
          'AAIco-settings_backup_restore' => 'MT Settings_backup_restore',
          'AAIco-settings_bluetooth' => 'MT Settings_bluetooth',
          'AAIco-settings_brightness' => 'MT Settings_brightness',
          'AAIco-settings_cell' => 'MT Settings_cell',
          'AAIco-settings_ethernet' => 'MT Settings_ethernet',
          'AAIco-settings_input_antenna' => 'MT Settings_input_antenna',
          'AAIco-settings_input_component' => 'MT Settings_input_component',
          'AAIco-settings_input_composite' => 'MT Settings_input_composite',
          'AAIco-settings_input_hdmi' => 'MT Settings_input_hdmi',
          'AAIco-settings_input_svideo' => 'MT Settings_input_svideo',
          'AAIco-settings_overscan' => 'MT Settings_overscan',
          'AAIco-settings_phone' => 'MT Settings_phone',
          'AAIco-settings_power' => 'MT Settings_power',
          'AAIco-settings_remote' => 'MT Settings_remote',
          'AAIco-settings_system_daydream' => 'MT Settings_system_daydream',
          'AAIco-settings_voice' => 'MT Settings_voice',
          'AAIco-share' => 'MT Share',
          'AAIco-shop' => 'MT Shop',
          'AAIco-shop_two' => 'MT Shop_two',
          'AAIco-shopping_basket' => 'MT Shopping_basket',
          'AAIco-shopping_cart' => 'MT Shopping_cart',
          'AAIco-short_text' => 'MT Short_text',
          'AAIco-show_chart' => 'MT Show_chart',
          'AAIco-shuffle' => 'MT Shuffle',
          'AAIco-signal_cellular_4_bar' => 'MT Signal_cellular_4_bar',
          'AAIco-signal_cellular_connected_no_internet_4_bar' => 'MT Signal_cellular_connected_no_internet_4_bar',
          'AAIco-signal_cellular_no_sim' => 'MT Signal_cellular_no_sim',
          'AAIco-signal_cellular_null' => 'MT Signal_cellular_null',
          'AAIco-signal_cellular_off' => 'MT Signal_cellular_off',
          'AAIco-signal_wifi_4_bar' => 'MT Signal_wifi_4_bar',
          'AAIco-signal_wifi_4_bar_lock' => 'MT Signal_wifi_4_bar_lock',
          'AAIco-signal_wifi_off' => 'MT Signal_wifi_off',
          'AAIco-sim_card' => 'MT Sim_card',
          'AAIco-sim_card_alert' => 'MT Sim_card_alert',
          'AAIco-skip_next' => 'MT Skip_next',
          'AAIco-skip_previous' => 'MT Skip_previous',
          'AAIco-slideshow' => 'MT Slideshow',
          'AAIco-slow_motion_video' => 'MT Slow_motion_video',
          'AAIco-smartphone' => 'MT Smartphone',
          'AAIco-smoke_free' => 'MT Smoke_free',
          'AAIco-smoking_rooms' => 'MT Smoking_rooms',
          'AAIco-sms' => 'MT Sms',
          'AAIco-sms_failed' => 'MT Sms_failed',
          'AAIco-snooze' => 'MT Snooze',
          'AAIco-sort' => 'MT Sort',
          'AAIco-sort_by_alpha' => 'MT Sort_by_alpha',
          'AAIco-spa' => 'MT Spa',
          'AAIco-space_bar' => 'MT Space_bar',
          'AAIco-speaker' => 'MT Speaker',
          'AAIco-speaker_group' => 'MT Speaker_group',
          'AAIco-speaker_notes' => 'MT Speaker_notes',
          'AAIco-speaker_notes_off' => 'MT Speaker_notes_off',
          'AAIco-speaker_phone' => 'MT Speaker_phone',
          'AAIco-spellcheck' => 'MT Spellcheck',
          'AAIco-star' => 'MT Star',
          'AAIco-star_border' => 'MT Star_border',
          'AAIco-star_half' => 'MT Star_half',
          'AAIco-stars' => 'MT Stars',
          'AAIco-stay_current_landscape' => 'MT Stay_current_landscape',
          'AAIco-stay_current_portrait' => 'MT Stay_current_portrait',
          'AAIco-stay_primary_landscape' => 'MT Stay_primary_landscape',
          'AAIco-stay_primary_portrait' => 'MT Stay_primary_portrait',
          'AAIco-stop' => 'MT Stop',
          'AAIco-stop_screen_share' => 'MT Stop_screen_share',
          'AAIco-storage' => 'MT Storage',
          'AAIco-store' => 'MT Store',
          'AAIco-store_mall_directory' => 'MT Store_mall_directory',
          'AAIco-straighten' => 'MT Straighten',
          'AAIco-streetview' => 'MT Streetview',
          'AAIco-strikethrough_s' => 'MT Strikethrough_s',
          'AAIco-style' => 'MT Style',
          'AAIco-subdirectory_arrow_left' => 'MT Subdirectory_arrow_left',
          'AAIco-subdirectory_arrow_right' => 'MT Subdirectory_arrow_right',
          'AAIco-subject' => 'MT Subject',
          'AAIco-subscriptions' => 'MT Subscriptions',
          'AAIco-subtitles' => 'MT Subtitles',
          'AAIco-subway' => 'MT Subway',
          'AAIco-supervisor_account' => 'MT Supervisor_account',
          'AAIco-surround_sound' => 'MT Surround_sound',
          'AAIco-swap_calls' => 'MT Swap_calls',
          'AAIco-swap_horiz' => 'MT Swap_horiz',
          'AAIco-swap_vert' => 'MT Swap_vert',
          'AAIco-swap_vertical_circle' => 'MT Swap_vertical_circle',
          'AAIco-switch_camera' => 'MT Switch_camera',
          'AAIco-switch_video' => 'MT Switch_video',
          'AAIco-sync' => 'MT Sync',
          'AAIco-sync_disabled' => 'MT Sync_disabled',
          'AAIco-sync_problem' => 'MT Sync_problem',
          'AAIco-system_update' => 'MT System_update',
          'AAIco-system_update_alt' => 'MT System_update_alt',
          'AAIco-tab' => 'MT Tab',
          'AAIco-tab_unselected' => 'MT Tab_unselected',
          'AAIco-tablet' => 'MT Tablet',
          'AAIco-tablet_android' => 'MT Tablet_android',
          'AAIco-tablet_mac' => 'MT Tablet_mac',
          'AAIco-tag_faces' => 'MT Tag_faces',
          'AAIco-tap_and_play' => 'MT Tap_and_play',
          'AAIco-terrain' => 'MT Terrain',
          'AAIco-text_fields' => 'MT Text_fields',
          'AAIco-text_format' => 'MT Text_format',
          'AAIco-textsms' => 'MT Textsms',
          'AAIco-texture' => 'MT Texture',
          'AAIco-theaters' => 'MT Theaters',
          'AAIco-thumb_down' => 'MT Thumb_down',
          'AAIco-thumb_up' => 'MT Thumb_up',
          'AAIco-thumbs_up_down' => 'MT Thumbs_up_down',
          'AAIco-time_to_leave' => 'MT Time_to_leave',
          'AAIco-timelapse' => 'MT Timelapse',
          'AAIco-timeline' => 'MT Timeline',
          'AAIco-timer' => 'MT Timer',
          'AAIco-timer_10' => 'MT Timer_10',
          'AAIco-timer_3' => 'MT Timer_3',
          'AAIco-timer_off' => 'MT Timer_off',
          'AAIco-title' => 'MT Title',
          'AAIco-toc' => 'MT Toc',
          'AAIco-today' => 'MT Today',
          'AAIco-toll' => 'MT Toll',
          'AAIco-tonality' => 'MT Tonality',
          'AAIco-touch_app' => 'MT Touch_app',
          'AAIco-toys' => 'MT Toys',
          'AAIco-track_changes' => 'MT Track_changes',
          'AAIco-traffic' => 'MT Traffic',
          'AAIco-train' => 'MT Train',
          'AAIco-tram' => 'MT Tram',
          'AAIco-transfer_within_a_station' => 'MT Transfer_within_a_station',
          'AAIco-transform' => 'MT Transform',
          'AAIco-translate' => 'MT Translate',
          'AAIco-trending_down' => 'MT Trending_down',
          'AAIco-trending_flat' => 'MT Trending_flat',
          'AAIco-trending_up' => 'MT Trending_up',
          'AAIco-tune' => 'MT Tune',
          'AAIco-turned_in' => 'MT Turned_in',
          'AAIco-turned_in_not' => 'MT Turned_in_not',
          'AAIco-tv' => 'MT Tv',
          'AAIco-unarchive' => 'MT Unarchive',
          'AAIco-undo' => 'MT Undo',
          'AAIco-unfold_less' => 'MT Unfold_less',
          'AAIco-unfold_more' => 'MT Unfold_more',
          'AAIco-update' => 'MT Update',
          'AAIco-usb' => 'MT Usb',
          'AAIco-verified_user' => 'MT Verified_user',
          'AAIco-vertical_align_bottom' => 'MT Vertical_align_bottom',
          'AAIco-vertical_align_center' => 'MT Vertical_align_center',
          'AAIco-vertical_align_top' => 'MT Vertical_align_top',
          'AAIco-vibration' => 'MT Vibration',
          'AAIco-video_call' => 'MT Video_call',
          'AAIco-video_label' => 'MT Video_label',
          'AAIco-video_library' => 'MT Video_library',
          'AAIco-videocam' => 'MT Videocam',
          'AAIco-videocam_off' => 'MT Videocam_off',
          'AAIco-videogame_asset' => 'MT Videogame_asset',
          'AAIco-view_agenda' => 'MT View_agenda',
          'AAIco-view_array' => 'MT View_array',
          'AAIco-view_carousel' => 'MT View_carousel',
          'AAIco-view_column' => 'MT View_column',
          'AAIco-view_comfy' => 'MT View_comfy',
          'AAIco-view_compact' => 'MT View_compact',
          'AAIco-view_day' => 'MT View_day',
          'AAIco-view_headline' => 'MT View_headline',
          'AAIco-view_list' => 'MT View_list',
          'AAIco-view_module' => 'MT View_module',
          'AAIco-view_quilt' => 'MT View_quilt',
          'AAIco-view_stream' => 'MT View_stream',
          'AAIco-view_week' => 'MT View_week',
          'AAIco-vignette' => 'MT Vignette',
          'AAIco-visibility' => 'MT Visibility',
          'AAIco-visibility_off' => 'MT Visibility_off',
          'AAIco-voice_chat' => 'MT Voice_chat',
          'AAIco-voicemail' => 'MT Voicemail',
          'AAIco-volume_down' => 'MT Volume_down',
          'AAIco-volume_mute' => 'MT Volume_mute',
          'AAIco-volume_off' => 'MT Volume_off',
          'AAIco-volume_up' => 'MT Volume_up',
          'AAIco-vpn_key' => 'MT Vpn_key',
          'AAIco-vpn_lock' => 'MT Vpn_lock',
          'AAIco-wallpaper' => 'MT Wallpaper',
          'AAIco-warning' => 'MT Warning',
          'AAIco-watch' => 'MT Watch',
          'AAIco-watch_later' => 'MT Watch_later',
          'AAIco-wb_auto' => 'MT Wb_auto',
          'AAIco-wb_cloudy' => 'MT Wb_cloudy',
          'AAIco-wb_incandescent' => 'MT Wb_incandescent',
          'AAIco-wb_iridescent' => 'MT Wb_iridescent',
          'AAIco-wb_sunny' => 'MT Wb_sunny',
          'AAIco-wc' => 'MT Wc',
          'AAIco-web' => 'MT Web',
          'AAIco-web_asset' => 'MT Web_asset',
          'AAIco-weekend' => 'MT Weekend',
          'AAIco-whatshot' => 'MT Whatshot',
          'AAIco-widgets' => 'MT Widgets',
          'AAIco-wifi' => 'MT Wifi',
          'AAIco-wifi_lock' => 'MT Wifi_lock',
          'AAIco-wifi_tethering' => 'MT Wifi_tethering',
          'AAIco-work' => 'MT Work',
          'AAIco-wrap_text' => 'MT Wrap_text',
          'AAIco-youtube_searched_for' => 'MT Youtube_searched_for',
          'AAIco-zoom_in' => 'MT Zoom_in',
          'AAIco-zoom_out' => 'MT Zoom_out',
          'AAIco-zoom_out_map' => 'MT Zoom_out_map',
        );
        
        $array2 = array(
          'fa-glass' => 'FWA Glass',
          'fa-music' => 'FWA Music',
          'fa-search' => 'FWA Search',
          'fa-envelope-o' => 'FWA Envelope-o',
          'fa-heart' => 'FWA Heart',
          'fa-star' => 'FWA Star',
          'fa-star-o' => 'FWA Star-o',
          'fa-user' => 'FWA User',
          'fa-film' => 'FWA Film',
          'fa-th-large' => 'FWA Th-large',
          'fa-th' => 'FWA Th',
          'fa-th-list' => 'FWA Th-list',
          'fa-check' => 'FWA Check',
          'fa-remove' => 'FWA Remove',
          'fa-close' => 'FWA Close',
          'fa-times' => 'FWA Times',
          'fa-search-plus' => 'FWA Search-plus',
          'fa-search-minus' => 'FWA Search-minus',
          'fa-power-off' => 'FWA Power-off',
          'fa-signal' => 'FWA Signal',
          'fa-gear' => 'FWA Gear',
          'fa-cog' => 'FWA Cog',
          'fa-trash-o' => 'FWA Trash-o',
          'fa-home' => 'FWA Home',
          'fa-file-o' => 'FWA File-o',
          'fa-clock-o' => 'FWA Clock-o',
          'fa-road' => 'FWA Road',
          'fa-download' => 'FWA Download',
          'fa-arrow-circle-o-down' => 'FWA Arrow-circle-o-down',
          'fa-arrow-circle-o-up' => 'FWA Arrow-circle-o-up',
          'fa-inbox' => 'FWA Inbox',
          'fa-play-circle-o' => 'FWA Play-circle-o',
          'fa-rotate-right' => 'FWA Rotate-right',
          'fa-repeat' => 'FWA Repeat',
          'fa-refresh' => 'FWA Refresh',
          'fa-list-alt' => 'FWA List-alt',
          'fa-lock' => 'FWA Lock',
          'fa-flag' => 'FWA Flag',
          'fa-headphones' => 'FWA Headphones',
          'fa-volume-off' => 'FWA Volume-off',
          'fa-volume-down' => 'FWA Volume-down',
          'fa-volume-up' => 'FWA Volume-up',
          'fa-qrcode' => 'FWA Qrcode',
          'fa-barcode' => 'FWA Barcode',
          'fa-tag' => 'FWA Tag',
          'fa-tags' => 'FWA Tags',
          'fa-book' => 'FWA Book',
          'fa-bookmark' => 'FWA Bookmark',
          'fa-print' => 'FWA Print',
          'fa-camera' => 'FWA Camera',
          'fa-font' => 'FWA Font',
          'fa-bold' => 'FWA Bold',
          'fa-italic' => 'FWA Italic',
          'fa-text-height' => 'FWA Text-height',
          'fa-text-width' => 'FWA Text-width',
          'fa-align-left' => 'FWA Align-left',
          'fa-align-center' => 'FWA Align-center',
          'fa-align-right' => 'FWA Align-right',
          'fa-align-justify' => 'FWA Align-justify',
          'fa-list' => 'FWA List',
          'fa-dedent' => 'FWA Dedent',
          'fa-outdent' => 'FWA Outdent',
          'fa-indent' => 'FWA Indent',
          'fa-video-camera' => 'FWA Video-camera',
          'fa-photo' => 'FWA Photo',
          'fa-image' => 'FWA Image',
          'fa-picture-o' => 'FWA Picture-o',
          'fa-pencil' => 'FWA Pencil',
          'fa-map-marker' => 'FWA Map-marker',
          'fa-adjust' => 'FWA Adjust',
          'fa-tint' => 'FWA Tint',
          'fa-edit' => 'FWA Edit',
          'fa-pencil-square-o' => 'FWA Pencil-square-o',
          'fa-share-square-o' => 'FWA Share-square-o',
          'fa-check-square-o' => 'FWA Check-square-o',
          'fa-arrows' => 'FWA Arrows',
          'fa-step-backward' => 'FWA Step-backward',
          'fa-fast-backward' => 'FWA Fast-backward',
          'fa-backward' => 'FWA Backward',
          'fa-play' => 'FWA Play',
          'fa-pause' => 'FWA Pause',
          'fa-stop' => 'FWA Stop',
          'fa-forward' => 'FWA Forward',
          'fa-fast-forward' => 'FWA Fast-forward',
          'fa-step-forward' => 'FWA Step-forward',
          'fa-eject' => 'FWA Eject',
          'fa-chevron-left' => 'FWA Chevron-left',
          'fa-chevron-right' => 'FWA Chevron-right',
          'fa-plus-circle' => 'FWA Plus-circle',
          'fa-minus-circle' => 'FWA Minus-circle',
          'fa-times-circle' => 'FWA Times-circle',
          'fa-check-circle' => 'FWA Check-circle',
          'fa-question-circle' => 'FWA Question-circle',
          'fa-info-circle' => 'FWA Info-circle',
          'fa-crosshairs' => 'FWA Crosshairs',
          'fa-times-circle-o' => 'FWA Times-circle-o',
          'fa-check-circle-o' => 'FWA Check-circle-o',
          'fa-ban' => 'FWA Ban',
          'fa-arrow-left' => 'FWA Arrow-left',
          'fa-arrow-right' => 'FWA Arrow-right',
          'fa-arrow-up' => 'FWA Arrow-up',
          'fa-arrow-down' => 'FWA Arrow-down',
          'fa-mail-forward' => 'FWA Mail-forward',
          'fa-share' => 'FWA Share',
          'fa-expand' => 'FWA Expand',
          'fa-compress' => 'FWA Compress',
          'fa-plus' => 'FWA Plus',
          'fa-minus' => 'FWA Minus',
          'fa-asterisk' => 'FWA Asterisk',
          'fa-exclamation-circle' => 'FWA Exclamation-circle',
          'fa-gift' => 'FWA Gift',
          'fa-leaf' => 'FWA Leaf',
          'fa-fire' => 'FWA Fire',
          'fa-eye' => 'FWA Eye',
          'fa-eye-slash' => 'FWA Eye-slash',
          'fa-warning' => 'FWA Warning',
          'fa-exclamation-triangle' => 'FWA Exclamation-triangle',
          'fa-plane' => 'FWA Plane',
          'fa-calendar' => 'FWA Calendar',
          'fa-random' => 'FWA Random',
          'fa-comment' => 'FWA Comment',
          'fa-magnet' => 'FWA Magnet',
          'fa-chevron-up' => 'FWA Chevron-up',
          'fa-chevron-down' => 'FWA Chevron-down',
          'fa-retweet' => 'FWA Retweet',
          'fa-shopping-cart' => 'FWA Shopping-cart',
          'fa-folder' => 'FWA Folder',
          'fa-folder-open' => 'FWA Folder-open',
          'fa-arrows-v' => 'FWA Arrows-v',
          'fa-arrows-h' => 'FWA Arrows-h',
          'fa-bar-chart-o' => 'FWA Bar-chart-o',
          'fa-bar-chart' => 'FWA Bar-chart',
          'fa-twitter-square' => 'FWA Twitter-square',
          'fa-facebook-square' => 'FWA Facebook-square',
          'fa-camera-retro' => 'FWA Camera-retro',
          'fa-key' => 'FWA Key',
          'fa-gears' => 'FWA Gears',
          'fa-cogs' => 'FWA Cogs',
          'fa-comments' => 'FWA Comments',
          'fa-thumbs-o-up' => 'FWA Thumbs-o-up',
          'fa-thumbs-o-down' => 'FWA Thumbs-o-down',
          'fa-star-half' => 'FWA Star-half',
          'fa-heart-o' => 'FWA Heart-o',
          'fa-sign-out' => 'FWA Sign-out',
          'fa-linkedin-square' => 'FWA Linkedin-square',
          'fa-thumb-tack' => 'FWA Thumb-tack',
          'fa-external-link' => 'FWA External-link',
          'fa-sign-in' => 'FWA Sign-in',
          'fa-trophy' => 'FWA Trophy',
          'fa-github-square' => 'FWA Github-square',
          'fa-upload' => 'FWA Upload',
          'fa-lemon-o' => 'FWA Lemon-o',
          'fa-phone' => 'FWA Phone',
          'fa-square-o' => 'FWA Square-o',
          'fa-bookmark-o' => 'FWA Bookmark-o',
          'fa-phone-square' => 'FWA Phone-square',
          'fa-twitter' => 'FWA Twitter',
          'fa-facebook-f' => 'FWA Facebook-f',
          'fa-facebook' => 'FWA Facebook',
          'fa-github' => 'FWA Github',
          'fa-unlock' => 'FWA Unlock',
          'fa-credit-card' => 'FWA Credit-card',
          'fa-feed' => 'FWA Feed',
          'fa-rss' => 'FWA Rss',
          'fa-hdd-o' => 'FWA Hdd-o',
          'fa-bullhorn' => 'FWA Bullhorn',
          'fa-bell' => 'FWA Bell',
          'fa-certificate' => 'FWA Certificate',
          'fa-hand-o-right' => 'FWA Hand-o-right',
          'fa-hand-o-left' => 'FWA Hand-o-left',
          'fa-hand-o-up' => 'FWA Hand-o-up',
          'fa-hand-o-down' => 'FWA Hand-o-down',
          'fa-arrow-circle-left' => 'FWA Arrow-circle-left',
          'fa-arrow-circle-right' => 'FWA Arrow-circle-right',
          'fa-arrow-circle-up' => 'FWA Arrow-circle-up',
          'fa-arrow-circle-down' => 'FWA Arrow-circle-down',
          'fa-globe' => 'FWA Globe',
          'fa-wrench' => 'FWA Wrench',
          'fa-tasks' => 'FWA Tasks',
          'fa-filter' => 'FWA Filter',
          'fa-briefcase' => 'FWA Briefcase',
          'fa-arrows-alt' => 'FWA Arrows-alt',
          'fa-group' => 'FWA Group',
          'fa-users' => 'FWA Users',
          'fa-chain' => 'FWA Chain',
          'fa-link' => 'FWA Link',
          'fa-cloud' => 'FWA Cloud',
          'fa-flask' => 'FWA Flask',
          'fa-cut' => 'FWA Cut',
          'fa-scissors' => 'FWA Scissors',
          'fa-copy' => 'FWA Copy',
          'fa-files-o' => 'FWA Files-o',
          'fa-paperclip' => 'FWA Paperclip',
          'fa-save' => 'FWA Save',
          'fa-floppy-o' => 'FWA Floppy-o',
          'fa-square' => 'FWA Square',
          'fa-navicon' => 'FWA Navicon',
          'fa-reorder' => 'FWA Reorder',
          'fa-bars' => 'FWA Bars',
          'fa-list-ul' => 'FWA List-ul',
          'fa-list-ol' => 'FWA List-ol',
          'fa-strikethrough' => 'FWA Strikethrough',
          'fa-underline' => 'FWA Underline',
          'fa-table' => 'FWA Table',
          'fa-magic' => 'FWA Magic',
          'fa-truck' => 'FWA Truck',
          'fa-pinterest' => 'FWA Pinterest',
          'fa-pinterest-square' => 'FWA Pinterest-square',
          'fa-google-plus-square' => 'FWA Google-plus-square',
          'fa-google-plus' => 'FWA Google-plus',
          'fa-money' => 'FWA Money',
          'fa-caret-down' => 'FWA Caret-down',
          'fa-caret-up' => 'FWA Caret-up',
          'fa-caret-left' => 'FWA Caret-left',
          'fa-caret-right' => 'FWA Caret-right',
          'fa-columns' => 'FWA Columns',
          'fa-unsorted' => 'FWA Unsorted',
          'fa-sort' => 'FWA Sort',
          'fa-sort-down' => 'FWA Sort-down',
          'fa-sort-desc' => 'FWA Sort-desc',
          'fa-sort-up' => 'FWA Sort-up',
          'fa-sort-asc' => 'FWA Sort-asc',
          'fa-envelope' => 'FWA Envelope',
          'fa-linkedin' => 'FWA Linkedin',
          'fa-rotate-left' => 'FWA Rotate-left',
          'fa-undo' => 'FWA Undo',
          'fa-legal' => 'FWA Legal',
          'fa-gavel' => 'FWA Gavel',
          'fa-dashboard' => 'FWA Dashboard',
          'fa-tachometer' => 'FWA Tachometer',
          'fa-comment-o' => 'FWA Comment-o',
          'fa-comments-o' => 'FWA Comments-o',
          'fa-flash' => 'FWA Flash',
          'fa-bolt' => 'FWA Bolt',
          'fa-sitemap' => 'FWA Sitemap',
          'fa-umbrella' => 'FWA Umbrella',
          'fa-paste' => 'FWA Paste',
          'fa-clipboard' => 'FWA Clipboard',
          'fa-lightbulb-o' => 'FWA Lightbulb-o',
          'fa-exchange' => 'FWA Exchange',
          'fa-cloud-download' => 'FWA Cloud-download',
          'fa-cloud-upload' => 'FWA Cloud-upload',
          'fa-user-md' => 'FWA User-md',
          'fa-stethoscope' => 'FWA Stethoscope',
          'fa-suitcase' => 'FWA Suitcase',
          'fa-bell-o' => 'FWA Bell-o',
          'fa-coffee' => 'FWA Coffee',
          'fa-cutlery' => 'FWA Cutlery',
          'fa-file-text-o' => 'FWA File-text-o',
          'fa-building-o' => 'FWA Building-o',
          'fa-hospital-o' => 'FWA Hospital-o',
          'fa-ambulance' => 'FWA Ambulance',
          'fa-medkit' => 'FWA Medkit',
          'fa-fighter-jet' => 'FWA Fighter-jet',
          'fa-beer' => 'FWA Beer',
          'fa-h-square' => 'FWA H-square',
          'fa-plus-square' => 'FWA Plus-square',
          'fa-angle-double-left' => 'FWA Angle-double-left',
          'fa-angle-double-right' => 'FWA Angle-double-right',
          'fa-angle-double-up' => 'FWA Angle-double-up',
          'fa-angle-double-down' => 'FWA Angle-double-down',
          'fa-angle-left' => 'FWA Angle-left',
          'fa-angle-right' => 'FWA Angle-right',
          'fa-angle-up' => 'FWA Angle-up',
          'fa-angle-down' => 'FWA Angle-down',
          'fa-desktop' => 'FWA Desktop',
          'fa-laptop' => 'FWA Laptop',
          'fa-tablet' => 'FWA Tablet',
          'fa-mobile-phone' => 'FWA Mobile-phone',
          'fa-mobile' => 'FWA Mobile',
          'fa-circle-o' => 'FWA Circle-o',
          'fa-quote-left' => 'FWA Quote-left',
          'fa-quote-right' => 'FWA Quote-right',
          'fa-spinner' => 'FWA Spinner',
          'fa-circle' => 'FWA Circle',
          'fa-mail-reply' => 'FWA Mail-reply',
          'fa-reply' => 'FWA Reply',
          'fa-github-alt' => 'FWA Github-alt',
          'fa-folder-o' => 'FWA Folder-o',
          'fa-folder-open-o' => 'FWA Folder-open-o',
          'fa-smile-o' => 'FWA Smile-o',
          'fa-frown-o' => 'FWA Frown-o',
          'fa-meh-o' => 'FWA Meh-o',
          'fa-gamepad' => 'FWA Gamepad',
          'fa-keyboard-o' => 'FWA Keyboard-o',
          'fa-flag-o' => 'FWA Flag-o',
          'fa-flag-checkered' => 'FWA Flag-checkered',
          'fa-terminal' => 'FWA Terminal',
          'fa-code' => 'FWA Code',
          'fa-mail-reply-all' => 'FWA Mail-reply-all',
          'fa-reply-all' => 'FWA Reply-all',
          'fa-star-half-empty' => 'FWA Star-half-empty',
          'fa-star-half-full' => 'FWA Star-half-full',
          'fa-star-half-o' => 'FWA Star-half-o',
          'fa-location-arrow' => 'FWA Location-arrow',
          'fa-crop' => 'FWA Crop',
          'fa-code-fork' => 'FWA Code-fork',
          'fa-unlink' => 'FWA Unlink',
          'fa-chain-broken' => 'FWA Chain-broken',
          'fa-question' => 'FWA Question',
          'fa-info' => 'FWA Info',
          'fa-exclamation' => 'FWA Exclamation',
          'fa-superscript' => 'FWA Superscript',
          'fa-subscript' => 'FWA Subscript',
          'fa-eraser' => 'FWA Eraser',
          'fa-puzzle-piece' => 'FWA Puzzle-piece',
          'fa-microphone' => 'FWA Microphone',
          'fa-microphone-slash' => 'FWA Microphone-slash',
          'fa-shield' => 'FWA Shield',
          'fa-calendar-o' => 'FWA Calendar-o',
          'fa-fire-extinguisher' => 'FWA Fire-extinguisher',
          'fa-rocket' => 'FWA Rocket',
          'fa-maxcdn' => 'FWA Maxcdn',
          'fa-chevron-circle-left' => 'FWA Chevron-circle-left',
          'fa-chevron-circle-right' => 'FWA Chevron-circle-right',
          'fa-chevron-circle-up' => 'FWA Chevron-circle-up',
          'fa-chevron-circle-down' => 'FWA Chevron-circle-down',
          'fa-html5' => 'FWA Html5',
          'fa-css3' => 'FWA Css3',
          'fa-anchor' => 'FWA Anchor',
          'fa-unlock-alt' => 'FWA Unlock-alt',
          'fa-bullseye' => 'FWA Bullseye',
          'fa-ellipsis-h' => 'FWA Ellipsis-h',
          'fa-ellipsis-v' => 'FWA Ellipsis-v',
          'fa-rss-square' => 'FWA Rss-square',
          'fa-play-circle' => 'FWA Play-circle',
          'fa-ticket' => 'FWA Ticket',
          'fa-minus-square' => 'FWA Minus-square',
          'fa-minus-square-o' => 'FWA Minus-square-o',
          'fa-level-up' => 'FWA Level-up',
          'fa-level-down' => 'FWA Level-down',
          'fa-check-square' => 'FWA Check-square',
          'fa-pencil-square' => 'FWA Pencil-square',
          'fa-external-link-square' => 'FWA External-link-square',
          'fa-share-square' => 'FWA Share-square',
          'fa-compass' => 'FWA Compass',
          'fa-toggle-down' => 'FWA Toggle-down',
          'fa-caret-square-o-down' => 'FWA Caret-square-o-down',
          'fa-toggle-up' => 'FWA Toggle-up',
          'fa-caret-square-o-up' => 'FWA Caret-square-o-up',
          'fa-toggle-right' => 'FWA Toggle-right',
          'fa-caret-square-o-right' => 'FWA Caret-square-o-right',
          'fa-euro' => 'FWA Euro',
          'fa-eur' => 'FWA Eur',
          'fa-gbp' => 'FWA Gbp',
          'fa-dollar' => 'FWA Dollar',
          'fa-usd' => 'FWA Usd',
          'fa-rupee' => 'FWA Rupee',
          'fa-inr' => 'FWA Inr',
          'fa-cny' => 'FWA Cny',
          'fa-rmb' => 'FWA Rmb',
          'fa-yen' => 'FWA Yen',
          'fa-jpy' => 'FWA Jpy',
          'fa-ruble' => 'FWA Ruble',
          'fa-rouble' => 'FWA Rouble',
          'fa-rub' => 'FWA Rub',
          'fa-won' => 'FWA Won',
          'fa-krw' => 'FWA Krw',
          'fa-bitcoin' => 'FWA Bitcoin',
          'fa-btc' => 'FWA Btc',
          'fa-file' => 'FWA File',
          'fa-file-text' => 'FWA File-text',
          'fa-sort-alpha-asc' => 'FWA Sort-alpha-asc',
          'fa-sort-alpha-desc' => 'FWA Sort-alpha-desc',
          'fa-sort-amount-asc' => 'FWA Sort-amount-asc',
          'fa-sort-amount-desc' => 'FWA Sort-amount-desc',
          'fa-sort-numeric-asc' => 'FWA Sort-numeric-asc',
          'fa-sort-numeric-desc' => 'FWA Sort-numeric-desc',
          'fa-thumbs-up' => 'FWA Thumbs-up',
          'fa-thumbs-down' => 'FWA Thumbs-down',
          'fa-youtube-square' => 'FWA Youtube-square',
          'fa-youtube' => 'FWA Youtube',
          'fa-xing' => 'FWA Xing',
          'fa-xing-square' => 'FWA Xing-square',
          'fa-youtube-play' => 'FWA Youtube-play',
          'fa-dropbox' => 'FWA Dropbox',
          'fa-stack-overflow' => 'FWA Stack-overflow',
          'fa-instagram' => 'FWA Instagram',
          'fa-flickr' => 'FWA Flickr',
          'fa-adn' => 'FWA Adn',
          'fa-bitbucket' => 'FWA Bitbucket',
          'fa-bitbucket-square' => 'FWA Bitbucket-square',
          'fa-tumblr' => 'FWA Tumblr',
          'fa-tumblr-square' => 'FWA Tumblr-square',
          'fa-long-arrow-down' => 'FWA Long-arrow-down',
          'fa-long-arrow-up' => 'FWA Long-arrow-up',
          'fa-long-arrow-left' => 'FWA Long-arrow-left',
          'fa-long-arrow-right' => 'FWA Long-arrow-right',
          'fa-apple' => 'FWA Apple',
          'fa-windows' => 'FWA Windows',
          'fa-android' => 'FWA Android',
          'fa-linux' => 'FWA Linux',
          'fa-dribbble' => 'FWA Dribbble',
          'fa-skype' => 'FWA Skype',
          'fa-foursquare' => 'FWA Foursquare',
          'fa-trello' => 'FWA Trello',
          'fa-female' => 'FWA Female',
          'fa-male' => 'FWA Male',
          'fa-gittip' => 'FWA Gittip',
          'fa-gratipay' => 'FWA Gratipay',
          'fa-sun-o' => 'FWA Sun-o',
          'fa-moon-o' => 'FWA Moon-o',
          'fa-archive' => 'FWA Archive',
          'fa-bug' => 'FWA Bug',
          'fa-vk' => 'FWA Vk',
          'fa-weibo' => 'FWA Weibo',
          'fa-renren' => 'FWA Renren',
          'fa-pagelines' => 'FWA Pagelines',
          'fa-stack-exchange' => 'FWA Stack-exchange',
          'fa-arrow-circle-o-right' => 'FWA Arrow-circle-o-right',
          'fa-arrow-circle-o-left' => 'FWA Arrow-circle-o-left',
          'fa-toggle-left' => 'FWA Toggle-left',
          'fa-caret-square-o-left' => 'FWA Caret-square-o-left',
          'fa-dot-circle-o' => 'FWA Dot-circle-o',
          'fa-wheelchair' => 'FWA Wheelchair',
          'fa-vimeo-square' => 'FWA Vimeo-square',
          'fa-turkish-lira' => 'FWA Turkish-lira',
          'fa-try' => 'FWA Try',
          'fa-plus-square-o' => 'FWA Plus-square-o',
          'fa-space-shuttle' => 'FWA Space-shuttle',
          'fa-slack' => 'FWA Slack',
          'fa-envelope-square' => 'FWA Envelope-square',
          'fa-wordpress' => 'FWA Wordpress',
          'fa-openid' => 'FWA Openid',
          'fa-institution' => 'FWA Institution',
          'fa-bank' => 'FWA Bank',
          'fa-university' => 'FWA University',
          'fa-mortar-board' => 'FWA Mortar-board',
          'fa-graduation-cap' => 'FWA Graduation-cap',
          'fa-yahoo' => 'FWA Yahoo',
          'fa-google' => 'FWA Google',
          'fa-reddit' => 'FWA Reddit',
          'fa-reddit-square' => 'FWA Reddit-square',
          'fa-stumbleupon-circle' => 'FWA Stumbleupon-circle',
          'fa-stumbleupon' => 'FWA Stumbleupon',
          'fa-delicious' => 'FWA Delicious',
          'fa-digg' => 'FWA Digg',
          'fa-pied-piper-pp' => 'FWA Pied-piper-pp',
          'fa-pied-piper-alt' => 'FWA Pied-piper-alt',
          'fa-drupal' => 'FWA Drupal',
          'fa-joomla' => 'FWA Joomla',
          'fa-language' => 'FWA Language',
          'fa-fax' => 'FWA Fax',
          'fa-building' => 'FWA Building',
          'fa-child' => 'FWA Child',
          'fa-paw' => 'FWA Paw',
          'fa-spoon' => 'FWA Spoon',
          'fa-cube' => 'FWA Cube',
          'fa-cubes' => 'FWA Cubes',
          'fa-behance' => 'FWA Behance',
          'fa-behance-square' => 'FWA Behance-square',
          'fa-steam' => 'FWA Steam',
          'fa-steam-square' => 'FWA Steam-square',
          'fa-recycle' => 'FWA Recycle',
          'fa-automobile' => 'FWA Automobile',
          'fa-car' => 'FWA Car',
          'fa-cab' => 'FWA Cab',
          'fa-taxi' => 'FWA Taxi',
          'fa-tree' => 'FWA Tree',
          'fa-spotify' => 'FWA Spotify',
          'fa-deviantart' => 'FWA Deviantart',
          'fa-soundcloud' => 'FWA Soundcloud',
          'fa-database' => 'FWA Database',
          'fa-file-pdf-o' => 'FWA File-pdf-o',
          'fa-file-word-o' => 'FWA File-word-o',
          'fa-file-excel-o' => 'FWA File-excel-o',
          'fa-file-powerpoint-o' => 'FWA File-powerpoint-o',
          'fa-file-photo-o' => 'FWA File-photo-o',
          'fa-file-picture-o' => 'FWA File-picture-o',
          'fa-file-image-o' => 'FWA File-image-o',
          'fa-file-zip-o' => 'FWA File-zip-o',
          'fa-file-archive-o' => 'FWA File-archive-o',
          'fa-file-sound-o' => 'FWA File-sound-o',
          'fa-file-audio-o' => 'FWA File-audio-o',
          'fa-file-movie-o' => 'FWA File-movie-o',
          'fa-file-video-o' => 'FWA File-video-o',
          'fa-file-code-o' => 'FWA File-code-o',
          'fa-vine' => 'FWA Vine',
          'fa-codepen' => 'FWA Codepen',
          'fa-jsfiddle' => 'FWA Jsfiddle',
          'fa-life-bouy' => 'FWA Life-bouy',
          'fa-life-buoy' => 'FWA Life-buoy',
          'fa-life-saver' => 'FWA Life-saver',
          'fa-support' => 'FWA Support',
          'fa-life-ring' => 'FWA Life-ring',
          'fa-circle-o-notch' => 'FWA Circle-o-notch',
          'fa-ra' => 'FWA Ra',
          'fa-resistance' => 'FWA Resistance',
          'fa-rebel' => 'FWA Rebel',
          'fa-ge' => 'FWA Ge',
          'fa-empire' => 'FWA Empire',
          'fa-git-square' => 'FWA Git-square',
          'fa-git' => 'FWA Git',
          'fa-y-combinator-square' => 'FWA Y-combinator-square',
          'fa-yc-square' => 'FWA Yc-square',
          'fa-hacker-news' => 'FWA Hacker-news',
          'fa-tencent-weibo' => 'FWA Tencent-weibo',
          'fa-qq' => 'FWA Qq',
          'fa-wechat' => 'FWA Wechat',
          'fa-weixin' => 'FWA Weixin',
          'fa-send' => 'FWA Send',
          'fa-paper-plane' => 'FWA Paper-plane',
          'fa-send-o' => 'FWA Send-o',
          'fa-paper-plane-o' => 'FWA Paper-plane-o',
          'fa-history' => 'FWA History',
          'fa-circle-thin' => 'FWA Circle-thin',
          'fa-header' => 'FWA Header',
          'fa-paragraph' => 'FWA Paragraph',
          'fa-sliders' => 'FWA Sliders',
          'fa-share-alt' => 'FWA Share-alt',
          'fa-share-alt-square' => 'FWA Share-alt-square',
          'fa-bomb' => 'FWA Bomb',
          'fa-soccer-ball-o' => 'FWA Soccer-ball-o',
          'fa-futbol-o' => 'FWA Futbol-o',
          'fa-tty' => 'FWA Tty',
          'fa-binoculars' => 'FWA Binoculars',
          'fa-plug' => 'FWA Plug',
          'fa-slideshare' => 'FWA Slideshare',
          'fa-twitch' => 'FWA Twitch',
          'fa-yelp' => 'FWA Yelp',
          'fa-newspaper-o' => 'FWA Newspaper-o',
          'fa-wifi' => 'FWA Wifi',
          'fa-calculator' => 'FWA Calculator',
          'fa-paypal' => 'FWA Paypal',
          'fa-google-wallet' => 'FWA Google-wallet',
          'fa-cc-visa' => 'FWA Cc-visa',
          'fa-cc-mastercard' => 'FWA Cc-mastercard',
          'fa-cc-discover' => 'FWA Cc-discover',
          'fa-cc-amex' => 'FWA Cc-amex',
          'fa-cc-paypal' => 'FWA Cc-paypal',
          'fa-cc-stripe' => 'FWA Cc-stripe',
          'fa-bell-slash' => 'FWA Bell-slash',
          'fa-bell-slash-o' => 'FWA Bell-slash-o',
          'fa-trash' => 'FWA Trash',
          'fa-copyright' => 'FWA Copyright',
          'fa-at' => 'FWA At',
          'fa-eyedropper' => 'FWA Eyedropper',
          'fa-paint-brush' => 'FWA Paint-brush',
          'fa-birthday-cake' => 'FWA Birthday-cake',
          'fa-area-chart' => 'FWA Area-chart',
          'fa-pie-chart' => 'FWA Pie-chart',
          'fa-line-chart' => 'FWA Line-chart',
          'fa-lastfm' => 'FWA Lastfm',
          'fa-lastfm-square' => 'FWA Lastfm-square',
          'fa-toggle-off' => 'FWA Toggle-off',
          'fa-toggle-on' => 'FWA Toggle-on',
          'fa-bicycle' => 'FWA Bicycle',
          'fa-bus' => 'FWA Bus',
          'fa-ioxhost' => 'FWA Ioxhost',
          'fa-angellist' => 'FWA Angellist',
          'fa-cc' => 'FWA Cc',
          'fa-shekel' => 'FWA Shekel',
          'fa-sheqel' => 'FWA Sheqel',
          'fa-ils' => 'FWA Ils',
          'fa-meanpath' => 'FWA Meanpath',
          'fa-buysellads' => 'FWA Buysellads',
          'fa-connectdevelop' => 'FWA Connectdevelop',
          'fa-dashcube' => 'FWA Dashcube',
          'fa-forumbee' => 'FWA Forumbee',
          'fa-leanpub' => 'FWA Leanpub',
          'fa-sellsy' => 'FWA Sellsy',
          'fa-shirtsinbulk' => 'FWA Shirtsinbulk',
          'fa-simplybuilt' => 'FWA Simplybuilt',
          'fa-skyatlas' => 'FWA Skyatlas',
          'fa-cart-plus' => 'FWA Cart-plus',
          'fa-cart-arrow-down' => 'FWA Cart-arrow-down',
          'fa-diamond' => 'FWA Diamond',
          'fa-ship' => 'FWA Ship',
          'fa-user-secret' => 'FWA User-secret',
          'fa-motorcycle' => 'FWA Motorcycle',
          'fa-street-view' => 'FWA Street-view',
          'fa-heartbeat' => 'FWA Heartbeat',
          'fa-venus' => 'FWA Venus',
          'fa-mars' => 'FWA Mars',
          'fa-mercury' => 'FWA Mercury',
          'fa-intersex' => 'FWA Intersex',
          'fa-transgender' => 'FWA Transgender',
          'fa-transgender-alt' => 'FWA Transgender-alt',
          'fa-venus-double' => 'FWA Venus-double',
          'fa-mars-double' => 'FWA Mars-double',
          'fa-venus-mars' => 'FWA Venus-mars',
          'fa-mars-stroke' => 'FWA Mars-stroke',
          'fa-mars-stroke-v' => 'FWA Mars-stroke-v',
          'fa-mars-stroke-h' => 'FWA Mars-stroke-h',
          'fa-neuter' => 'FWA Neuter',
          'fa-genderless' => 'FWA Genderless',
          'fa-facebook-official' => 'FWA Facebook-official',
          'fa-pinterest-p' => 'FWA Pinterest-p',
          'fa-whatsapp' => 'FWA Whatsapp',
          'fa-server' => 'FWA Server',
          'fa-user-plus' => 'FWA User-plus',
          'fa-user-times' => 'FWA User-times',
          'fa-hotel' => 'FWA Hotel',
          'fa-bed' => 'FWA Bed',
          'fa-viacoin' => 'FWA Viacoin',
          'fa-train' => 'FWA Train',
          'fa-subway' => 'FWA Subway',
          'fa-medium' => 'FWA Medium',
          'fa-yc' => 'FWA Yc',
          'fa-y-combinator' => 'FWA Y-combinator',
          'fa-optin-monster' => 'FWA Optin-monster',
          'fa-opencart' => 'FWA Opencart',
          'fa-expeditedssl' => 'FWA Expeditedssl',
          'fa-battery-4' => 'FWA Battery-4',
          'fa-battery' => 'FWA Battery',
          'fa-battery-full' => 'FWA Battery-full',
          'fa-battery-3' => 'FWA Battery-3',
          'fa-battery-three-quarters' => 'FWA Battery-three-quarters',
          'fa-battery-2' => 'FWA Battery-2',
          'fa-battery-half' => 'FWA Battery-half',
          'fa-battery-1' => 'FWA Battery-1',
          'fa-battery-quarter' => 'FWA Battery-quarter',
          'fa-battery-0' => 'FWA Battery-0',
          'fa-battery-empty' => 'FWA Battery-empty',
          'fa-mouse-pointer' => 'FWA Mouse-pointer',
          'fa-i-cursor' => 'FWA I-cursor',
          'fa-object-group' => 'FWA Object-group',
          'fa-object-ungroup' => 'FWA Object-ungroup',
          'fa-sticky-note' => 'FWA Sticky-note',
          'fa-sticky-note-o' => 'FWA Sticky-note-o',
          'fa-cc-jcb' => 'FWA Cc-jcb',
          'fa-cc-diners-club' => 'FWA Cc-diners-club',
          'fa-clone' => 'FWA Clone',
          'fa-balance-scale' => 'FWA Balance-scale',
          'fa-hourglass-o' => 'FWA Hourglass-o',
          'fa-hourglass-1' => 'FWA Hourglass-1',
          'fa-hourglass-start' => 'FWA Hourglass-start',
          'fa-hourglass-2' => 'FWA Hourglass-2',
          'fa-hourglass-half' => 'FWA Hourglass-half',
          'fa-hourglass-3' => 'FWA Hourglass-3',
          'fa-hourglass-end' => 'FWA Hourglass-end',
          'fa-hourglass' => 'FWA Hourglass',
          'fa-hand-grab-o' => 'FWA Hand-grab-o',
          'fa-hand-rock-o' => 'FWA Hand-rock-o',
          'fa-hand-stop-o' => 'FWA Hand-stop-o',
          'fa-hand-paper-o' => 'FWA Hand-paper-o',
          'fa-hand-scissors-o' => 'FWA Hand-scissors-o',
          'fa-hand-lizard-o' => 'FWA Hand-lizard-o',
          'fa-hand-spock-o' => 'FWA Hand-spock-o',
          'fa-hand-pointer-o' => 'FWA Hand-pointer-o',
          'fa-hand-peace-o' => 'FWA Hand-peace-o',
          'fa-trademark' => 'FWA Trademark',
          'fa-registered' => 'FWA Registered',
          'fa-creative-commons' => 'FWA Creative-commons',
          'fa-gg' => 'FWA Gg',
          'fa-gg-circle' => 'FWA Gg-circle',
          'fa-tripadvisor' => 'FWA Tripadvisor',
          'fa-odnoklassniki' => 'FWA Odnoklassniki',
          'fa-odnoklassniki-square' => 'FWA Odnoklassniki-square',
          'fa-get-pocket' => 'FWA Get-pocket',
          'fa-wikipedia-w' => 'FWA Wikipedia-w',
          'fa-safari' => 'FWA Safari',
          'fa-chrome' => 'FWA Chrome',
          'fa-firefox' => 'FWA Firefox',
          'fa-opera' => 'FWA Opera',
          'fa-internet-explorer' => 'FWA Internet-explorer',
          'fa-tv' => 'FWA Tv',
          'fa-television' => 'FWA Television',
          'fa-contao' => 'FWA Contao',
          'fa-500px' => 'FWA 500px',
          'fa-amazon' => 'FWA Amazon',
          'fa-calendar-plus-o' => 'FWA Calendar-plus-o',
          'fa-calendar-minus-o' => 'FWA Calendar-minus-o',
          'fa-calendar-times-o' => 'FWA Calendar-times-o',
          'fa-calendar-check-o' => 'FWA Calendar-check-o',
          'fa-industry' => 'FWA Industry',
          'fa-map-pin' => 'FWA Map-pin',
          'fa-map-signs' => 'FWA Map-signs',
          'fa-map-o' => 'FWA Map-o',
          'fa-map' => 'FWA Map',
          'fa-commenting' => 'FWA Commenting',
          'fa-commenting-o' => 'FWA Commenting-o',
          'fa-houzz' => 'FWA Houzz',
          'fa-vimeo' => 'FWA Vimeo',
          'fa-black-tie' => 'FWA Black-tie',
          'fa-fonticons' => 'FWA Fonticons',
          'fa-reddit-alien' => 'FWA Reddit-alien',
          'fa-edge' => 'FWA Edge',
          'fa-credit-card-alt' => 'FWA Credit-card-alt',
          'fa-codiepie' => 'FWA Codiepie',
          'fa-modx' => 'FWA Modx',
          'fa-fort-awesome' => 'FWA Fort-awesome',
          'fa-usb' => 'FWA Usb',
          'fa-product-hunt' => 'FWA Product-hunt',
          'fa-mixcloud' => 'FWA Mixcloud',
          'fa-scribd' => 'FWA Scribd',
          'fa-pause-circle' => 'FWA Pause-circle',
          'fa-pause-circle-o' => 'FWA Pause-circle-o',
          'fa-stop-circle' => 'FWA Stop-circle',
          'fa-stop-circle-o' => 'FWA Stop-circle-o',
          'fa-shopping-bag' => 'FWA Shopping-bag',
          'fa-shopping-basket' => 'FWA Shopping-basket',
          'fa-hashtag' => 'FWA Hashtag',
          'fa-bluetooth' => 'FWA Bluetooth',
          'fa-bluetooth-b' => 'FWA Bluetooth-b',
          'fa-percent' => 'FWA Percent',
          'fa-gitlab' => 'FWA Gitlab',
          'fa-wpbeginner' => 'FWA Wpbeginner',
          'fa-wpforms' => 'FWA Wpforms',
          'fa-envira' => 'FWA Envira',
          'fa-universal-access' => 'FWA Universal-access',
          'fa-wheelchair-alt' => 'FWA Wheelchair-alt',
          'fa-question-circle-o' => 'FWA Question-circle-o',
          'fa-blind' => 'FWA Blind',
          'fa-audio-description' => 'FWA Audio-description',
          'fa-volume-control-phone' => 'FWA Volume-control-phone',
          'fa-braille' => 'FWA Braille',
          'fa-assistive-listening-systems' => 'FWA Assistive-listening-systems',
          'fa-asl-interpreting' => 'FWA Asl-interpreting',
          'fa-american-sign-language-interpreting' => 'FWA American-sign-language-interpreting',
          'fa-deafness' => 'FWA Deafness',
          'fa-hard-of-hearing' => 'FWA Hard-of-hearing',
          'fa-deaf' => 'FWA Deaf',
          'fa-glide' => 'FWA Glide',
          'fa-glide-g' => 'FWA Glide-g',
          'fa-signing' => 'FWA Signing',
          'fa-sign-language' => 'FWA Sign-language',
          'fa-low-vision' => 'FWA Low-vision',
          'fa-viadeo' => 'FWA Viadeo',
          'fa-viadeo-square' => 'FWA Viadeo-square',
          'fa-snapchat' => 'FWA Snapchat',
          'fa-snapchat-ghost' => 'FWA Snapchat-ghost',
          'fa-snapchat-square' => 'FWA Snapchat-square',
          'fa-pied-piper' => 'FWA Pied-piper',
          'fa-first-order' => 'FWA First-order',
          'fa-yoast' => 'FWA Yoast',
          'fa-themeisle' => 'FWA Themeisle',
          'fa-google-plus-circle' => 'FWA Google-plus-circle',
          'fa-google-plus-official' => 'FWA Google-plus-official',
          'fa-fa' => 'FWA Fa',
          'fa-font-awesome' => 'FWA Font-awesome',
          'fa-handshake-o' => 'FWA Handshake-o',
          'fa-envelope-open' => 'FWA Envelope-open',
          'fa-envelope-open-o' => 'FWA Envelope-open-o',
          'fa-linode' => 'FWA Linode',
          'fa-address-book' => 'FWA Address-book',
          'fa-address-book-o' => 'FWA Address-book-o',
          'fa-vcard' => 'FWA Vcard',
          'fa-address-card' => 'FWA Address-card',
          'fa-vcard-o' => 'FWA Vcard-o',
          'fa-address-card-o' => 'FWA Address-card-o',
          'fa-user-circle' => 'FWA User-circle',
          'fa-user-circle-o' => 'FWA User-circle-o',
          'fa-user-o' => 'FWA User-o',
          'fa-id-badge' => 'FWA Id-badge',
          'fa-drivers-license' => 'FWA Drivers-license',
          'fa-id-card' => 'FWA Id-card',
          'fa-drivers-license-o' => 'FWA Drivers-license-o',
          'fa-id-card-o' => 'FWA Id-card-o',
          'fa-quora' => 'FWA Quora',
          'fa-free-code-camp' => 'FWA Free-code-camp',
          'fa-telegram' => 'FWA Telegram',
          'fa-thermometer-4' => 'FWA Thermometer-4',
          'fa-thermometer' => 'FWA Thermometer',
          'fa-thermometer-full' => 'FWA Thermometer-full',
          'fa-thermometer-3' => 'FWA Thermometer-3',
          'fa-thermometer-three-quarters' => 'FWA Thermometer-three-quarters',
          'fa-thermometer-2' => 'FWA Thermometer-2',
          'fa-thermometer-half' => 'FWA Thermometer-half',
          'fa-thermometer-1' => 'FWA Thermometer-1',
          'fa-thermometer-quarter' => 'FWA Thermometer-quarter',
          'fa-thermometer-0' => 'FWA Thermometer-0',
          'fa-thermometer-empty' => 'FWA Thermometer-empty',
          'fa-shower' => 'FWA Shower',
          'fa-bathtub' => 'FWA Bathtub',
          'fa-s15' => 'FWA S15',
          'fa-bath' => 'FWA Bath',
          'fa-podcast' => 'FWA Podcast',
          'fa-window-maximize' => 'FWA Window-maximize',
          'fa-window-minimize' => 'FWA Window-minimize',
          'fa-window-restore' => 'FWA Window-restore',
          'fa-times-rectangle' => 'FWA Times-rectangle',
          'fa-window-close' => 'FWA Window-close',
          'fa-times-rectangle-o' => 'FWA Times-rectangle-o',
          'fa-window-close-o' => 'FWA Window-close-o',
          'fa-bandcamp' => 'FWA Bandcamp',
          'fa-grav' => 'FWA Grav',
          'fa-etsy' => 'FWA Etsy',
          'fa-imdb' => 'FWA Imdb',
          'fa-ravelry' => 'FWA Ravelry',
          'fa-eercast' => 'FWA Eercast',
          'fa-microchip' => 'FWA Microchip',
          'fa-snowflake-o' => 'FWA Snowflake-o',
          'fa-superpowers' => 'FWA Superpowers',
          'fa-wpexplorer' => 'FWA Wpexplorer',
          'fa-meetup' => 'FWA Meetup',
        );
        
        //$result_array = array_merge($array, $array2);
        
        if($_POST['type']==1){ $result_array = $array; }else{ $result_array = $array2; }
        
        if(!empty($_POST['value'])){
            $result = tr_stristrarray($result_array, esc_html($_POST['value']) );
            foreach($result as $k => $v){
                echo '<li class="'.$k.'">'.$v.'</li>';
            }
            if(empty($result)){ echo '<li class="trnoresults">'.__('No results found.', 'toroplay').'</li>'; }
        }else{
            foreach($result_array as $k => $v){
                echo '<li class="'.$k.'">'.$v.'</li>';
            }
        }
        
    }
    
    wp_die();

}

function tr_stristrarray($array, $str){
    $indexes = array();
    foreach($array as $k => $v){
        if(stristr($v, $str)){
            $indexes[$k] = $v;
        }
    }
    return $indexes;
}

add_action('admin_menu', 'remove_unnecessary_wordpress_menus', 999);

function remove_unnecessary_wordpress_menus(){
    global $submenu;
    foreach($submenu['themes.php'] as $menu_index => $theme_menu){
        if(count(explode('l%5D=header_image', $theme_menu[2]))==2){
            unset($submenu['themes.php'][$menu_index]);
        }
        if(count(explode('l%5D=background_image', $theme_menu[2]))==2){
            unset($submenu['themes.php'][$menu_index]);
        }
    }
}
?>